/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class StoreClientHelper {
    private StoreClientHelper() {
    }

    public static JSONArray convert(ResultSet rs) throws SQLException, JSONException {
        JSONArray json = new JSONArray();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            int numColumns = rsmd.getColumnCount();
            JSONObject obj = new JSONObject();
            for (int i = 1; i <= numColumns; ++i) {
                Object value;
                String columnName = rsmd.getColumnName(i);
                switch (rsmd.getColumnType(i)) {
                    case 2003: {
                        value = rs.getArray(columnName);
                        break;
                    }
                    case 16: {
                        value = rs.getBoolean(columnName);
                        break;
                    }
                    case 2004: {
                        value = rs.getBlob(columnName);
                        break;
                    }
                    case 8: {
                        value = rs.getDouble(columnName);
                        break;
                    }
                    case 6: {
                        value = Float.valueOf(rs.getFloat(columnName));
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        value = rs.getInt(columnName);
                        break;
                    }
                    case -9: {
                        value = rs.getNString(columnName);
                        break;
                    }
                    case 12: {
                        value = rs.getString(columnName);
                        break;
                    }
                    case 91: {
                        value = rs.getDate(columnName);
                        break;
                    }
                    case 93: {
                        value = rs.getTimestamp(columnName);
                        break;
                    }
                    default: {
                        value = rs.getObject(columnName);
                    }
                }
                obj.put(columnName, value);
            }
            json.put(obj);
        }
        return json;
    }
}

