/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class MiscUtil {
    public static String notNull(JSONObject jo, String key) {
        if (jo.isNull(key)) {
            throw new JPSRuntimeException("missing input parameter " + key);
        }
        return jo.getString(key);
    }

    public static String format(String s, Object ... args) {
        return String.format(Locale.ENGLISH, s, args);
    }

    public static String concat(String[] a, String separator) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i]);
            if (i >= a.length - 1) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static List<String> toList(JSONArray ja) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object current : ja.toList()) {
            result.add(current.toString());
        }
        return result;
    }

    public static String optNullKey(JSONObject jo, String key) {
        if (jo.isNull(key)) {
            return null;
        }
        return jo.getString(key);
    }

    public static String convertToTimeZoneXSD(String currDate) {
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        try {
            SimpleDateFormat utcFormat = new SimpleDateFormat(DATE_FORMAT);
            utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = utcFormat.parse(currDate);
            TimeZone timezone = TimeZone.getDefault();
            int offset = timezone.getRawOffset();
            String gmtTZ = String.format("%s%02d:%02d", offset < 0 ? "-" : "+", Math.abs(offset) / 3600000, Math.abs(offset) / 60000 % 60);
            SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss" + gmtTZ);
            return newFormat.format(date);
        }
        catch (ParseException e) {
            throw new JPSRuntimeException("WeatherIrradiationRetriever: Parse Exception for date");
        }
    }
}

