/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSONKeyToIRIMapper {
    private String iriPrefix;
    private final HashMap<String, String> jsonToIRIMapping = new HashMap();
    private final HashMap<String, String> iriToJSONMapping = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger(JSONKeyToIRIMapper.class);
    private static final String FILE_NOT_FOUND_MSG = "No properties file found at specified filepath: %s";
    private static final String DUPLICATE_IRI_MSG = "The IRI %s is already used for the key %s, and can not be used for key %s";
    private static final String NOT_VALID_URI_MSG = "The value for key %s is not a valid URI: %s";

    public JSONKeyToIRIMapper() {
    }

    public JSONKeyToIRIMapper(String iriPrefix) {
        this.setIRIPrefix(iriPrefix);
    }

    public JSONKeyToIRIMapper(String iriPrefix, String filepath) throws IOException {
        this.setIRIPrefix(iriPrefix);
        this.readMappingFromFile(filepath);
    }

    public void readMappingFromFile(String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists()) {
            LOGGER.error(String.format(FILE_NOT_FOUND_MSG, filepath));
            throw new FileNotFoundException(String.format(FILE_NOT_FOUND_MSG, filepath));
        }
        try (FileInputStream input = new FileInputStream(file);){
            Properties prop = new Properties();
            prop.load(input);
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String key = String.valueOf(entry.getKey());
                String value = String.valueOf(entry.getValue());
                if (value.isEmpty()) {
                    value = this.generateIRI(this.iriPrefix, key);
                    LOGGER.info("No IRI provided for key " + key + ". The IRI was automatically generated: " + value);
                }
                if (this.checkIRI(value)) {
                    String oldKey = this.iriToJSONMapping.get(value);
                    if (oldKey != null) {
                        LOGGER.error(String.format(DUPLICATE_IRI_MSG, value, oldKey, key));
                        throw new IOException(String.format(DUPLICATE_IRI_MSG, value, oldKey, key));
                    }
                    this.jsonToIRIMapping.put(key, value);
                    this.iriToJSONMapping.put(value, key);
                    continue;
                }
                LOGGER.error(String.format(NOT_VALID_URI_MSG, key, value));
                throw new IOException(String.format(NOT_VALID_URI_MSG, key, value));
            }
        }
    }

    public void saveToFile(String filepath) throws IOException {
        File file = new File(filepath);
        try (FileOutputStream output = new FileOutputStream(file, false);){
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.jsonToIRIMapping);
            prop.store(output, "Note: URLs might look like this: http\\:// \nThis is to escape the ':' symbol and ensure that the properties can be loaded in properly.");
        }
    }

    public String generateIRI(String prefix, String jsonKey) {
        return String.join((CharSequence)"_", prefix, jsonKey, UUID.randomUUID().toString());
    }

    public String getIRI(String jsonKey) {
        return this.jsonToIRIMapping.get(jsonKey);
    }

    public String getJSONKey(String iri) {
        return this.iriToJSONMapping.get(iri);
    }

    public List<String> getAllIRIs() {
        return new ArrayList<String>(this.iriToJSONMapping.keySet());
    }

    public List<String> getAllJSONKeys() {
        return new ArrayList<String>(this.jsonToIRIMapping.keySet());
    }

    public String getIRIPrefix() {
        return this.iriPrefix;
    }

    public void setIRIPrefix(String iriPrefix) {
        if (!this.checkIRI(iriPrefix)) {
            throw new IllegalArgumentException(iriPrefix + " is not a valid IRI.");
        }
        this.iriPrefix = iriPrefix;
    }

    private boolean checkIRI(String iri) {
        return Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(iri).matches();
    }
}

