/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class CommandHelper {
    private static Logger LOGGER = LogManager.getLogger(CommandHelper.class);
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static String executeSingleCommand(String targetFolder, String command) {
        LOGGER.info("In folder: " + targetFolder + " Excuted: " + command);
        return CommandHelper.getCommandResultString(CommandHelper.getCommandProcess(targetFolder, command));
    }

    public static String executeCommands(String targetFolder, ArrayList<String> commands) {
        LOGGER.info("In folder: " + targetFolder + " Excuted: " + commands);
        String[] command = commands.toArray(new String[0]);
        String resultString = CommandHelper.getCommandResultString(CommandHelper.getCommandProcess(targetFolder, command));
        int min = Math.min(resultString.length(), 200);
        LOGGER.info("=== Result (only the first 200 characters) === :" + resultString.substring(0, min));
        return resultString;
    }

    public static String executeAsyncSingleCommand(String targetFolder, String command) {
        LOGGER.info("In folder: " + targetFolder + " Excuted: " + command);
        return CommandHelper.getCommandResultString(CommandHelper.getAsyncCommandProcess(targetFolder, command));
    }

    public static String getCommandResultString(Process pr) {
        BufferedReader bfr = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        StringBuilder resultString = new StringBuilder();
        try {
            String line;
            while ((line = bfr.readLine()) != null) {
                resultString.append(line);
            }
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return resultString.toString();
    }

    private static Process getCommandProcess(String targetFolder, String command) {
        Process pr;
        try {
            pr = Runtime.getRuntime().exec(command, null, new File(targetFolder));
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return pr;
    }

    private static Process getCommandProcess(String targetFolder, String[] command) {
        Process pr;
        try {
            pr = Runtime.getRuntime().exec(command, null, new File(targetFolder));
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return pr;
    }

    private static Process getAsyncCommandProcess(String targetFolder, String command) {
        Process pr = null;
        try {
            if (CommandHelper.isWindows()) {
                pr = Runtime.getRuntime().exec("cmd /c start " + command, null, new File(targetFolder));
            } else if (CommandHelper.isMac()) {
                pr = Runtime.getRuntime().exec("open " + command, null, new File(targetFolder));
            }
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return pr;
    }
}

