/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.tools;

import java.sql.SQLException;
import java.time.LocalDateTime;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;

public class TaggingCloningTool {
    String strTag = "_Tag";
    boolean splitUpdate = true;
    int stepSize;
    int countTotal;
    boolean quads = true;
    static ExprFactory exprFactory = new ExprFactory();
    static String varCount = "count";
    static Var newS = Var.alloc("newS");
    static Var varS = Var.alloc("s");
    static Var varP = Var.alloc("p");
    static Var varO = Var.alloc("o");
    static Var varG = Var.alloc("g");
    static ExprVar exprS = new ExprVar(varS);
    static ExprVar exprP = new ExprVar(varP);
    static ExprVar exprO = new ExprVar(varO);
    static ExprVar exprG = new ExprVar(varG);
    static Expr exprStrS = exprFactory.str(exprS);

    public TaggingCloningTool() {
        this.stepSize = 1000000;
    }

    public TaggingCloningTool(int stepSize) {
        this.stepSize = stepSize;
    }

    public void setCloneSize(int stepSize) {
        this.stepSize = stepSize;
    }

    public void setSingleStepClone() {
        this.splitUpdate = false;
    }

    public void setTripleStore() {
        this.quads = false;
    }

    public void setQuadsStore() {
        this.quads = true;
    }

    public void clone(TripleStoreClientInterface sourceKB, TripleStoreClientInterface targetKB) {
        this.clone(sourceKB, null, targetKB, null);
    }

    public void clone(TripleStoreClientInterface sourceKB, TripleStoreClientInterface targetKB, String graph) {
        this.clone(sourceKB, graph, targetKB, graph);
    }

    public void clone(TripleStoreClientInterface sourceKB, String sourceGraph, TripleStoreClientInterface targetKB, String targetGraph) {
        WhereBuilder whereCountAll = new WhereBuilder().addWhere(varS, varP, varO);
        this.countTotal = this.countTriples(sourceKB, sourceGraph, whereCountAll);
        if (!this.splitUpdate) {
            this.singleStepClone(sourceKB, sourceGraph, targetKB, targetGraph);
        } else if (this.countTotal <= this.stepSize) {
            this.singleStepClone(sourceKB, sourceGraph, targetKB, targetGraph);
        } else {
            this.performClone(sourceKB, sourceGraph, targetKB, targetGraph);
        }
    }

    public void singleStepClone(TripleStoreClientInterface sourceKB, String sourceGraph, TripleStoreClientInterface targetKB, String targetGraph) {
        Query construct = TaggingCloningTool.buildSparqlConstruct(sourceGraph);
        Model results = sourceKB.executeConstruct(construct);
        UpdateRequest update = TaggingCloningTool.buildSparqlUpdate(targetGraph, results);
        targetKB.executeUpdate(update);
    }

    private void performClone(TripleStoreClientInterface sourceKB, String sourceGraph, TripleStoreClientInterface targetKB, String targetGraph) {
        this.createTag(sourceKB);
        WhereBuilder whereCount = new WhereBuilder().addWhere(varS, varP, varO).addFilter(this.exprFilterOutBlanks());
        int count = this.countTriples(sourceKB, sourceGraph, whereCount);
        int steps = count / this.stepSize;
        if (count % this.stepSize > 0) {
            ++steps;
        }
        for (int i = 0; i < steps; ++i) {
            Expr exprTagN = this.buildExprTagN(i);
            WhereBuilder whereNotTagged = new WhereBuilder().addWhere(varS, varP, varO).addFilter(this.exprFilterOutBlanks()).addFilter(this.exprNotTagged()).addBind(exprFactory.iri(exprFactory.concat(exprStrS, exprTagN)), (Object)newS);
            UpdateRequest tagUpdate = this.buildTagUpdate(sourceGraph, whereNotTagged, this.stepSize, this.quads);
            try {
                sourceKB.executeUpdate(tagUpdate);
            }
            catch (Exception e) {
                if (e.getCause() instanceof SQLException) {
                    throw new JPSRuntimeException("CloningTool: tagging update failed! SourceKB might not be quads. Try setTripleStore().", e);
                }
                throw e;
            }
            WhereBuilder whereConstructTagged = new WhereBuilder().addWhere(varS, varP, varO).addFilter(exprFactory.strends(exprStrS, exprTagN));
            Query constructQuery = this.buildConstruct(sourceGraph, whereConstructTagged);
            Model triples = sourceKB.executeConstruct(constructQuery);
            WhereBuilder whereRemoveTag = new WhereBuilder().addWhere(varS, varP, varO).addBind(this.exprBindIriRemoveTag(exprTagN), (Object)newS);
            UpdateRequest removeTagUpdate = this.buildTagUpdate(null, whereRemoveTag, 0, false);
            Dataset dataset = DatasetFactory.create(triples);
            UpdateExecution updateExec = UpdateExecutionFactory.create(removeTagUpdate, dataset);
            updateExec.execute();
            UpdateRequest update = TaggingCloningTool.buildInsert(targetGraph, dataset.getDefaultModel());
            targetKB.executeUpdate(update);
        }
        E_LogicalOr filterTag = exprFactory.or(this.exprNotTagged(), exprFactory.isBlank(exprS));
        WhereBuilder whereConstruct = new WhereBuilder().addWhere(varS, varP, varO).addFilter(filterTag);
        Query constructQuery = this.buildConstruct(sourceGraph, whereConstruct);
        Model triples = sourceKB.executeConstruct(constructQuery);
        UpdateRequest update = TaggingCloningTool.buildInsert(targetGraph, triples);
        targetKB.executeUpdate(update);
        for (int i = 0; i < steps; ++i) {
            Expr exprTagN = this.buildExprTagN(i);
            WhereBuilder whereTagged = new WhereBuilder().addWhere(varS, varP, varO).addFilter(exprFactory.strends(exprStrS, exprTagN)).addBind(this.exprBindIriRemoveTag(exprTagN), (Object)newS);
            UpdateRequest tagUpdate = this.buildTagUpdate(sourceGraph, whereTagged, this.stepSize, this.quads);
            sourceKB.executeUpdate(tagUpdate);
        }
    }

    private void createTag(TripleStoreClientInterface kbClient) {
        LocalDateTime dateTime = LocalDateTime.now();
        String name = kbClient.getQueryEndpoint() + dateTime.toString();
        int hash = name.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        this.strTag = this.strTag + String.valueOf(hash);
    }

    public boolean checkCount(TripleStoreClientInterface kbClient, String graph) {
        WhereBuilder whereCount = new WhereBuilder().addWhere(varS, varP, varO);
        int count = this.countTriples(kbClient, graph, whereCount);
        return count == this.countTotal;
    }

    public boolean checkNoTags(TripleStoreClientInterface kbClient, String graph) {
        WhereBuilder whereCount = new WhereBuilder().addWhere(varS, varP, varO).addFilter(this.exprTagged());
        int count = this.countTriples(kbClient, graph, whereCount);
        return count == 0;
    }

    private int countTriples(TripleStoreClientInterface kbClient, String graph, WhereBuilder where) {
        String query = this.countQuery(graph, where);
        JSONArray result = kbClient.executeQuery(query);
        JSONObject jsonobject = result.getJSONObject(0);
        return jsonobject.getInt(varCount);
    }

    private String countQuery(String graph, WhereBuilder whereFilter) {
        WhereBuilder where = null;
        if (graph != null) {
            where = new WhereBuilder();
            String graphURI = "<" + graph + ">";
            where.addGraph((Object)graphURI, (AbstractQueryBuilder)whereFilter);
        } else {
            where = whereFilter;
        }
        String query = "SELECT (COUNT(*) AS ?" + varCount + ") ";
        query = query + where.toString();
        return query;
    }

    private Query buildConstruct(String graph, WhereBuilder where) {
        ConstructBuilder builder = new ConstructBuilder().addConstruct(varS, varP, varO);
        if (graph == null) {
            builder.addWhere(where);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
        }
        return builder.build();
    }

    private static UpdateRequest buildInsert(String graph, Model triples) {
        UpdateBuilder builder = new UpdateBuilder();
        if (graph == null) {
            builder.addInsert(triples);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addInsert((Object)graphURI, triples);
        }
        return builder.buildRequest();
    }

    private UpdateRequest buildTagUpdate(String graph, WhereBuilder where, int limit, boolean quads) {
        SelectBuilder select = new SelectBuilder();
        select.addVar(varS).addVar(varP).addVar(varO).addVar(newS);
        if (limit > 0) {
            select.setLimit(limit);
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (quads) {
            if (graph == null) {
                select.addVar(varG);
                select.addGraph((Object)varG, (AbstractQueryBuilder)where);
                builder.addInsert(varG, newS, varP, varO).addDelete(varG, varS, varP, varO).addSubQuery(select);
            } else {
                String graphURI = "<" + graph + ">";
                select.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
                builder.addInsert(graphURI, newS, varP, varO).addDelete(graphURI, varS, varP, varO).addSubQuery(select);
            }
        } else {
            select.addWhere(where);
            builder.addInsert(newS, varP, varO).addDelete(varS, varP, varO).addSubQuery(select);
        }
        return builder.buildRequest();
    }

    private Expr buildExprTagN(int i) {
        return exprFactory.asExpr("_" + Integer.toString(i) + this.strTag);
    }

    private Expr exprFilterOutBlanks() {
        return exprFactory.and(exprFactory.not(exprFactory.isBlank(exprS)), exprFactory.and(exprFactory.not(exprFactory.isBlank(exprP)), exprFactory.not(exprFactory.isBlank(exprO))));
    }

    private Expr exprNotTagged() {
        return exprFactory.not(this.exprTagged());
    }

    private Expr exprTagged() {
        return exprFactory.strends(exprStrS, this.strTag);
    }

    private Expr exprBindIriRemoveTag(Expr exprTagN) {
        return exprFactory.iri(exprFactory.replace(exprStrS, exprTagN, ""));
    }

    private static Query buildSparqlConstruct(String graph) {
        ConstructBuilder builder = new ConstructBuilder().addConstruct(varS, varP, varO);
        if (graph == null) {
            builder.addWhere(varS, varP, varO);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addGraph(graphURI, varS, varP, varO);
        }
        return builder.build();
    }

    private static UpdateRequest buildSparqlUpdate(String graph, Model results) {
        UpdateBuilder builder = new UpdateBuilder();
        if (graph == null) {
            builder.addInsert(results);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addInsert((Object)graphURI, results);
        }
        return builder.buildRequest();
    }
}

