/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.core.Assignment;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.DeleteDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.InsertDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatternNotTriples;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.derivation.ValuesPattern;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;

public class TimeSeriesSparql {
    private TripleStoreClientInterface kbClient;
    public static final String TIMESERIES_NAMESPACE = "https://www.theworldavatar.com/kg/ontotimeseries/";
    public static final String NS_TIME = "http://www.w3.org/2006/time#";
    private static final Prefix PREFIX_ONTOLOGY = SparqlBuilder.prefix("ts", Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/"));
    private static final Prefix PREFIX_KB = SparqlBuilder.prefix("kb", Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/"));
    private static final Prefix PREFIX_TIME = SparqlBuilder.prefix("time", Rdf.iri("http://www.w3.org/2006/time#"));
    private static final Iri hasTimeSeries = PREFIX_ONTOLOGY.iri("hasTimeSeries");
    private static final Iri hasRDB = PREFIX_ONTOLOGY.iri("hasRDB");
    private static final Iri hasTimeUnit = PREFIX_ONTOLOGY.iri("hasTimeUnit");
    private static final Iri hasAveragingPeriod = PREFIX_ONTOLOGY.iri("hasAveragingPeriod");
    private static final Iri numericDuration = PREFIX_TIME.iri("numericDuration");
    private static final Iri unitType = PREFIX_TIME.iri("unitType");
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";
    public static final String AVERAGE_TYPE_STRING = "https://www.theworldavatar.com/kg/ontotimeseries/AverageTimeSeries";
    public static final String STEPWISE_CUMULATIVE_TYPE_STRING = "https://www.theworldavatar.com/kg/ontotimeseries/StepwiseCumulativeTimeSeries";
    public static final String CUMULATIVE_TOTAL_TYPE_STRING = "https://www.theworldavatar.com/kg/ontotimeseries/CumulativeTotalTimeSeries";
    public static final String INSTANTANEOUS_TYPE_STRING = "https://www.theworldavatar.com/kg/ontotimeseries/InstantaneousTimeSeries";
    public static final String TIMESERIES_TYPE_STRING = "https://www.theworldavatar.com/kg/ontotimeseries/TimeSeries";
    public static final Iri TIMESERIES = Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/TimeSeries");
    public static final Iri STEPWISE_CUMULATIVE_TIMESERIES = Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/StepwiseCumulativeTimeSeries");
    public static final Iri CUMULATIVE_TOTAL_TIMESERIES = Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/CumulativeTotalTimeSeries");
    public static final Iri AVERAGE_TIMESERIES = Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/AverageTimeSeries");
    public static final Iri INSTANTANEOUS_TIMESERIES = Rdf.iri("https://www.theworldavatar.com/kg/ontotimeseries/InstantaneousTimeSeries");
    private static final Iri Duration = PREFIX_TIME.iri("Duration");
    private static final List<RdfObject> types = Arrays.asList(TIMESERIES, CUMULATIVE_TOTAL_TIMESERIES, STEPWISE_CUMULATIVE_TIMESERIES, AVERAGE_TIMESERIES, INSTANTANEOUS_TIMESERIES);
    private static final Variable tsType = Queries.SELECT(new Projectable[0]).var();
    private static final ValuesPattern vp = new ValuesPattern(tsType, types);
    private final ArrayList<String> temporalUnitType = new ArrayList<String>(Arrays.asList("http://www.w3.org/2006/time#unitSecond", "http://www.w3.org/2006/time#unitMinute", "http://www.w3.org/2006/time#unitHour", "http://www.w3.org/2006/time#unitDay", "http://www.w3.org/2006/time#unitWeek", "http://www.w3.org/2006/time#unitMonth", "http://www.w3.org/2006/time#unitYear"));
    private static EnumMap<ChronoUnit, String> temporalUnitMap = new EnumMap(ChronoUnit.class);
    private static final Logger LOGGER;

    public TimeSeriesSparql(TripleStoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    public void setKBClient(TripleStoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    protected void loadSparqlConfigs(String filepath) throws IOException {
        block8: {
            File file = new File(filepath);
            if (!file.exists()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "No properties file found at specified filepath: " + filepath);
            }
            try (FileInputStream input = new FileInputStream(file);){
                Properties prop = new Properties();
                prop.load(input);
                if (!prop.containsKey("sparql.query.endpoint")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.query.endpoint=<sparql_endpoint>\" ");
                }
                this.kbClient.setQueryEndpoint(prop.getProperty("sparql.query.endpoint"));
                if (prop.containsKey("sparql.update.endpoint")) {
                    this.kbClient.setUpdateEndpoint(prop.getProperty("sparql.update.endpoint"));
                    break block8;
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.update.endpoint=<sparql_endpoint>\" ");
            }
        }
    }

    protected CustomDuration getCustomDuration(String tsIRI) {
        CustomDuration duration = null;
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable value = SparqlBuilder.var("value");
        Variable unit = SparqlBuilder.var("unit");
        Variable dur = SparqlBuilder.var("dur");
        TriplePattern queryPattern1 = Rdf.iri(tsIRI).has((RdfPredicate)hasAveragingPeriod, dur);
        TriplePattern queryPattern2 = dur.has((RdfPredicate)numericDuration, value).andHas((RdfPredicate)unitType, unit);
        ((SelectQuery)((SelectQuery)query.select(value, unit).where(queryPattern1, queryPattern2)).prefix(PREFIX_TIME)).prefix(PREFIX_ONTOLOGY);
        JSONArray result = this.kbClient.executeQuery(query.getQueryString());
        if (!result.isEmpty()) {
            duration = new CustomDuration(Double.valueOf(result.getJSONObject(0).getString("value")), result.getJSONObject(0).getString("unit"));
        }
        return duration;
    }

    private String getDurationIRI(String temporalUnit, Double numericValue) {
        String durationIRI = null;
        String queryString = "periodIRI";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable periodIRI = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = periodIRI.has((RdfPredicate)numericDuration, numericValue).andHas((RdfPredicate)unitType, Rdf.iri(temporalUnit));
        ((SelectQuery)query.select(periodIRI).where(queryPattern)).prefix(PREFIX_TIME);
        JSONArray result = this.kbClient.executeQuery(query.getQueryString());
        if (!result.isEmpty()) {
            durationIRI = result.getJSONObject(0).getString(queryString);
        }
        return durationIRI;
    }

    private Map<CustomDuration, String> createDurationIRIMapping() {
        HashMap<CustomDuration, String> durationMap = new HashMap<CustomDuration, String>();
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable durIRI = SparqlBuilder.var("durIRI");
        Variable value = SparqlBuilder.var("value");
        Variable unit = SparqlBuilder.var("unit");
        TriplePattern queryPattern = durIRI.has((RdfPredicate)numericDuration, value).andHas((RdfPredicate)unitType, unit);
        ((SelectQuery)query.select(durIRI, value, unit).where(queryPattern)).prefix(PREFIX_TIME);
        JSONArray result = this.kbClient.executeQuery(query.getQueryString());
        for (int i = 0; i < result.length(); ++i) {
            CustomDuration duration = new CustomDuration(Double.valueOf(result.getJSONObject(i).getString("value")), result.getJSONObject(i).getString("unit"));
            durationMap.put(duration, result.getJSONObject(i).getString("durIRI"));
        }
        return durationMap;
    }

    private void removeAverageTimeSeries(String tsIRI) {
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        Variable predicate1 = SparqlBuilder.var("a");
        Variable predicate2 = SparqlBuilder.var("b");
        Variable subject = SparqlBuilder.var("c");
        Variable object1 = SparqlBuilder.var("d");
        Variable predicate3 = SparqlBuilder.var("e");
        Variable object2 = SparqlBuilder.var("f");
        Variable durIRI = SparqlBuilder.var("durIRI");
        TriplePattern deleteTp1 = Rdf.iri(tsIRI).has((RdfPredicate)predicate1, object1);
        TriplePattern deleteTp2 = subject.has((RdfPredicate)predicate2, Rdf.iri(tsIRI));
        TriplePattern deleteTp3 = Rdf.iri(tsIRI).has((RdfPredicate)hasAveragingPeriod, durIRI);
        TriplePattern deleteTp4 = durIRI.has((RdfPredicate)predicate3, object2);
        sub.select(predicate1, predicate2, predicate3, subject, object1, object2, durIRI).where(deleteTp1, deleteTp2, deleteTp3, deleteTp4);
        ModifyQuery modify = Queries.MODIFY();
        modify.delete(deleteTp1, deleteTp2, deleteTp3, deleteTp4).where(sub).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(modify.getQueryString());
        this.kbClient.executeUpdate();
    }

    protected String getAveragingPeriod(String tsIRI) {
        String averagingPeriodIRI = null;
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryString = "durIRI";
        Variable durIRI = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = Rdf.iri(tsIRI).has((RdfPredicate)hasAveragingPeriod, durIRI);
        ((SelectQuery)query.select(durIRI).where(queryPattern)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        JSONArray result = this.kbClient.executeQuery();
        if (!result.isEmpty()) {
            averagingPeriodIRI = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return averagingPeriodIRI;
    }

    public boolean checkTimeSeriesExists(String timeSeriesIRI) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        TriplePattern queryPattern = Rdf.iri(timeSeriesIRI).isA(tsType);
        ((SelectQuery)query.select(tsType).where(queryPattern, vp)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        return !this.kbClient.executeQuery(query.getQueryString()).isEmpty();
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", dataIRI, "https://www.theworldavatar.com/kg/ontotimeseries/hasTimeSeries");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", tsIRI, "https://www.theworldavatar.com/kg/ontotimeseries/hasTimeUnit");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    protected void initTS(String timeSeriesIRI, List<String> dataIRI, String dbURL, String timeUnit, Iri type, Duration duration, ChronoUnit unit) {
        if (!Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(timeSeriesIRI).matches()) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series IRI does not have valid IRI format");
        }
        Iri tsIRI = Rdf.iri(timeSeriesIRI);
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(PREFIX_ONTOLOGY, PREFIX_KB, PREFIX_TIME);
        modify.insert(tsIRI.isA(type));
        if (type.equals(AVERAGE_TIMESERIES)) {
            if (duration.getNano() != 0) {
                LOGGER.warn("Nano is ignored");
            }
            if (duration.isNegative() || duration.isZero()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Numeric Duration must be a positive value");
            }
            if (!temporalUnitMap.containsKey(unit)) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Temporal Unit: " + unit.toString() + " of invalid type");
            }
            Double numericValue = duration.getSeconds() / unit.getDuration().getSeconds();
            String temporalUnit = temporalUnitMap.get(unit);
            String durationIRI = this.getDurationIRI(temporalUnit, numericValue);
            if (durationIRI != null) {
                modify.insert(tsIRI.has((RdfPredicate)hasAveragingPeriod, Rdf.iri(durationIRI)));
            } else {
                durationIRI = "https://www.theworldavatar.com/kg/ontotimeseries/AveragingPeriod_" + UUID.randomUUID();
                modify.insert(tsIRI.has((RdfPredicate)hasAveragingPeriod, Rdf.iri(durationIRI)));
                modify.insert(Rdf.iri(durationIRI).isA(Duration));
                modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)unitType, Rdf.iri(temporalUnit)));
                modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)numericDuration, numericValue));
            }
        }
        for (String iri : dataIRI) {
            String ts = this.getTimeSeries(iri);
            if (ts == null) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + iri + " is already attached to time series " + ts);
        }
        modify.insert(tsIRI.has((RdfPredicate)hasRDB, Rdf.literalOf(dbURL)));
        for (String data : dataIRI) {
            TriplePattern ts_tp = Rdf.iri(data).has((RdfPredicate)hasTimeSeries, tsIRI);
            modify.insert(ts_tp);
        }
        if (timeUnit != null) {
            modify.insert(tsIRI.has((RdfPredicate)hasTimeUnit, Rdf.literalOf(timeUnit)));
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    protected void bulkInitTS(List<String> tsIRIs, List<List<String>> dataIRIs, String rdbURL, List<String> timeUnit, List<Iri> types, List<Duration> durations, List<ChronoUnit> units) {
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(PREFIX_ONTOLOGY, PREFIX_KB, PREFIX_TIME);
        Map<CustomDuration, String> durationMap = this.createDurationIRIMapping();
        for (int i = 0; i < tsIRIs.size(); ++i) {
            if (!Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(tsIRIs.get(i)).matches()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Time series IRI does not have valid IRI format");
            }
            Iri tsIRI = Rdf.iri(tsIRIs.get(i));
            modify.insert(tsIRI.isA(types.get(i)));
            if (types.get(i).equals(AVERAGE_TIMESERIES)) {
                if (durations.get(i).getNano() != 0) {
                    LOGGER.warn("Nano is ignored");
                }
                if ((double)durations.get(i).getSeconds() <= 0.0) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Numeric Duration must be a positive value");
                }
                if (!temporalUnitMap.containsKey(units.get(i))) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Temporal Unit: " + units.get(i).toString() + " of invalid type");
                }
                Double numericValue = durations.get(i).getSeconds() / units.get(i).getDuration().getSeconds();
                String temporalUnit = temporalUnitMap.get(units.get(i));
                CustomDuration key = new CustomDuration(numericValue, temporalUnit);
                String durationIRI = null;
                if (durationMap.containsKey(key)) {
                    durationIRI = durationMap.get(key);
                }
                if (durationIRI != null) {
                    modify.insert(tsIRI.has((RdfPredicate)hasAveragingPeriod, Rdf.iri(durationIRI)));
                } else {
                    durationIRI = "https://www.theworldavatar.com/kg/ontotimeseries/AveragingPeriod_" + UUID.randomUUID();
                    modify.insert(tsIRI.has((RdfPredicate)hasAveragingPeriod, Rdf.iri(durationIRI)));
                    modify.insert(Rdf.iri(durationIRI).isA(Duration));
                    modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)unitType, Rdf.iri(temporalUnit)));
                    modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)numericDuration, numericValue));
                }
            }
            modify.insert(tsIRI.has((RdfPredicate)hasRDB, Rdf.literalOf(rdbURL)));
            for (String data : dataIRIs.get(i)) {
                TriplePattern tsTp = Rdf.iri(data).has((RdfPredicate)hasTimeSeries, tsIRI);
                modify.insert(tsTp);
            }
            if (timeUnit.get(i) == null) continue;
            modify.insert(tsIRI.has((RdfPredicate)hasTimeUnit, Rdf.literalOf(timeUnit.get(i))));
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    boolean checkAnyTimeSeriesExists(List<String> dataIRI) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable data = query.var();
        Variable ts = query.var();
        ValuesPattern valuesPattern = new ValuesPattern(data, dataIRI.stream().map(Rdf::iri).collect(Collectors.toList()));
        ((SelectQuery)query.where(data.has((RdfPredicate)hasTimeSeries, ts), valuesPattern)).prefix(PREFIX_ONTOLOGY);
        JSONArray queryResult = this.kbClient.executeQuery(query.getQueryString());
        return queryResult.length() > 0;
    }

    public int countTS() {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryKey = "numtimeseries";
        Variable ts = SparqlBuilder.var("ts");
        Variable numtimeseries = SparqlBuilder.var(queryKey);
        TriplePattern querypattern = ts.isA(tsType);
        Assignment count = Expressions.count(ts).as(numtimeseries);
        ((SelectQuery)query.select(count).where(querypattern, vp)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        return this.kbClient.executeQuery().getJSONObject(0).getInt(queryKey);
    }

    protected void insertTimeSeriesAssociation(String dataIRI, String tsIRI) {
        String ts = this.getTimeSeries(dataIRI);
        if (ts != null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + dataIRI + " is already attached to time series " + ts);
        }
        if (!this.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series " + tsIRI + " does not exists in the Knowledge Graph");
        }
        InsertDataQuery insert = Queries.INSERT_DATA(Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI)));
        insert.prefix(PREFIX_ONTOLOGY);
        this.kbClient.executeUpdate(insert.getQueryString());
    }

    protected void removeTimeSeriesAssociation(String dataIRI) {
        String tsIRI = this.getTimeSeries(dataIRI);
        if (tsIRI != null) {
            List<String> data = this.getAssociatedData(tsIRI);
            if (data.size() == 1) {
                this.removeTimeSeries(tsIRI);
            } else {
                DeleteDataQuery delete = Queries.DELETE_DATA(Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI)));
                delete.prefix(PREFIX_ONTOLOGY);
                this.kbClient.executeUpdate(delete.getQueryString());
            }
        }
    }

    protected void removeTimeSeries(String tsIRI) {
        if (this.checkTimeSeriesExists(tsIRI)) {
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            String queryKey = "numTs";
            Variable ts = SparqlBuilder.var("ts");
            Variable durIRI = SparqlBuilder.var("durIRI");
            Variable numTs = SparqlBuilder.var(queryKey);
            TriplePattern queryPattern1 = Rdf.iri(tsIRI).has((RdfPredicate)hasAveragingPeriod, durIRI);
            TriplePattern queryPattern2 = ts.has((RdfPredicate)hasAveragingPeriod, durIRI);
            Assignment count = Expressions.count(ts).as(numTs);
            ((SelectQuery)query.select(count).where(queryPattern1, queryPattern2)).prefix(PREFIX_ONTOLOGY);
            this.kbClient.setQuery(query.getQueryString());
            Integer avgTsIris = this.kbClient.executeQuery().getJSONObject(0).getInt(queryKey);
            if (avgTsIris == 1) {
                this.removeAverageTimeSeries(tsIRI);
            } else {
                SubSelect sub = GraphPatterns.select(new Projectable[0]);
                Variable predicate1 = SparqlBuilder.var("a");
                Variable predicate2 = SparqlBuilder.var("b");
                Variable subject = SparqlBuilder.var("c");
                Variable object = SparqlBuilder.var("d");
                TriplePattern deleteTp1 = Rdf.iri(tsIRI).has((RdfPredicate)predicate1, object);
                TriplePattern deleteTp2 = subject.has((RdfPredicate)predicate2, Rdf.iri(tsIRI));
                sub.select(predicate1, predicate2, subject, object).where(deleteTp1, deleteTp2);
                ModifyQuery modify = Queries.MODIFY();
                modify.delete(deleteTp1, deleteTp2).where(sub);
                this.kbClient.setQuery(modify.getQueryString());
                this.kbClient.executeUpdate();
            }
        }
    }

    protected String getTimeSeriesType(String tsIRI) {
        String result = null;
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        TriplePattern queryPattern = Rdf.iri(tsIRI).isA(tsType);
        ((SelectQuery)query.select(tsType).where(queryPattern, vp)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        if (!queryResult.isEmpty()) {
            result = queryResult.getJSONObject(0).getString(tsType.getQueryString().substring(1));
        }
        return result;
    }

    protected void removeAllTimeSeries() {
        Variable predicate1 = SparqlBuilder.var("p1");
        Variable predicate2 = SparqlBuilder.var("p2");
        Variable predicate3 = SparqlBuilder.var("p3");
        Variable subject1 = SparqlBuilder.var("s1");
        Variable object1 = SparqlBuilder.var("o1");
        Variable object2 = SparqlBuilder.var("o2");
        Variable timeseries = SparqlBuilder.var("ts");
        Variable dur = SparqlBuilder.var("dur");
        TriplePattern deleteTp1 = timeseries.has((RdfPredicate)predicate1, object1);
        TriplePattern deleteTp2 = subject1.has((RdfPredicate)predicate2, timeseries);
        TriplePattern deleteTp3 = timeseries.has((RdfPredicate)hasAveragingPeriod, dur);
        TriplePattern deleteTp4 = dur.has((RdfPredicate)predicate3, object2);
        GraphPatternNotTriples optional = GraphPatterns.optional(deleteTp3, deleteTp4);
        ModifyQuery modify = Queries.MODIFY();
        modify.delete(deleteTp1, deleteTp2, deleteTp3, deleteTp4).where(timeseries.isA(tsType), deleteTp1, deleteTp2, optional, vp).prefix(PREFIX_ONTOLOGY);
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    public String getTimeSeries(String dataIRI) {
        String result = null;
        String queryString = "tsIRI";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable tsIRI = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, tsIRI);
        ((SelectQuery)query.select(tsIRI).where(queryPattern)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        if (!queryResult.isEmpty()) {
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getDbUrl(String tsIRI) {
        String result = null;
        String queryString = "dbURL";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable dbURL = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = Rdf.iri(tsIRI).has((RdfPredicate)hasRDB, dbURL);
        ((SelectQuery)query.select(dbURL).where(queryPattern)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        if (!queryResult.isEmpty()) {
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getTimeUnit(String tsIRI) {
        String result = null;
        String queryString = "timeUnit";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable timeUnit = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = Rdf.iri(tsIRI).has((RdfPredicate)hasTimeUnit, timeUnit);
        ((SelectQuery)query.select(timeUnit).where(queryPattern)).prefix(PREFIX_ONTOLOGY);
        this.kbClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        if (!queryResult.isEmpty()) {
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public List<String> getAssociatedData(String tsIRI) {
        String queryString = "dataIRI";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable data = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = data.has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI));
        ((SelectQuery)query.select(data).where(queryPattern)).prefix(PREFIX_ONTOLOGY);
        return this.getInstances(query, queryString);
    }

    public List<String> getAllTimeSeries() {
        String queryString = "ts";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable ts = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = ts.isA(tsType);
        ((SelectQuery)query.select(ts).where(queryPattern, vp)).prefix(PREFIX_ONTOLOGY);
        return this.getInstances(query, queryString);
    }

    private List<String> getInstances(SelectQuery instanceSelectQuery, String placeholder) {
        this.kbClient.setQuery(instanceSelectQuery.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        ArrayList<String> instanceIRIs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            instanceIRIs.add(queryResult.getJSONObject(i).getString(placeholder));
        }
        return instanceIRIs;
    }

    protected void initTS(String timeSeriesIRI, List<String> dataIRI, String dbURL, String timeUnit, Iri type, String durationIRI, Double duration, String unit) {
        if (!Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(timeSeriesIRI).matches()) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series IRI does not have valid IRI format");
        }
        Iri tsIRI = Rdf.iri(timeSeriesIRI);
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(PREFIX_ONTOLOGY, PREFIX_KB, PREFIX_TIME);
        modify.insert(tsIRI.isA(type));
        if (type.equals(AVERAGE_TIMESERIES)) {
            if (duration <= 0.0) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Numeric Duration must be a positive value");
            }
            if (!this.temporalUnitType.contains(unit)) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Temporal Unit: " + unit + " of invalid type");
            }
            modify.insert(tsIRI.has((RdfPredicate)hasAveragingPeriod, Rdf.iri(durationIRI)));
            modify.insert(Rdf.iri(durationIRI).isA(Duration));
            modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)unitType, Rdf.iri(unit)));
            modify.insert(Rdf.iri(durationIRI).has((RdfPredicate)numericDuration, duration));
        }
        for (String iri : dataIRI) {
            String ts = this.getTimeSeries(iri);
            if (ts == null) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + iri + " is already attached to time series " + ts);
        }
        modify.insert(tsIRI.has((RdfPredicate)hasRDB, Rdf.literalOf(dbURL)));
        for (String data : dataIRI) {
            TriplePattern tsTp = Rdf.iri(data).has((RdfPredicate)hasTimeSeries, tsIRI);
            modify.insert(tsTp);
        }
        if (timeUnit != null) {
            modify.insert(tsIRI.has((RdfPredicate)hasTimeUnit, Rdf.literalOf(timeUnit)));
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    static {
        temporalUnitMap.put(ChronoUnit.SECONDS, "http://www.w3.org/2006/time#unitSecond");
        temporalUnitMap.put(ChronoUnit.MINUTES, "http://www.w3.org/2006/time#unitMinute");
        temporalUnitMap.put(ChronoUnit.HOURS, "http://www.w3.org/2006/time#unitHour");
        temporalUnitMap.put(ChronoUnit.DAYS, "http://www.w3.org/2006/time#unitDay");
        temporalUnitMap.put(ChronoUnit.WEEKS, "http://www.w3.org/2006/time#unitWeek");
        temporalUnitMap.put(ChronoUnit.MONTHS, "http://www.w3.org/2006/time#unitMonth");
        temporalUnitMap.put(ChronoUnit.YEARS, "http://www.w3.org/2006/time#unitYear");
        LOGGER = LogManager.getLogger(TimeSeriesSparql.class);
    }

    protected class CustomDuration {
        private final Double value;
        private final String unit;
        private int hashCode;

        public CustomDuration(Double value, String unit) {
            this.value = value;
            this.unit = unit;
            this.hashCode = Objects.hash(value, unit);
        }

        public double getValue() {
            return this.value;
        }

        public String getUnit() {
            return this.unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomDuration that = (CustomDuration)o;
            return this.value.equals(that.value) && this.unit.equals(that.unit);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

