/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesRDBClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesSparql;

public class TimeSeriesClient<T> {
    private static final Logger LOGGER = LogManager.getLogger(TimeSeriesClient.class);
    private TimeSeriesRDBClient<T> rdbClient;
    private TimeSeriesSparql rdfClient;
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";
    private static final String CONNECTION_ERROR = "Failed to connect to database. If you are using the methods without the connection argument, the RDB endpoint (URL, username and password) needs to be set in the constructor of TimeSeriesClient";

    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
    }

    public void setKBClient(TripleStoreClientInterface kbClient) {
        this.rdfClient.setKBClient(kbClient);
    }

    public void setRDBSchema(String schema) {
        this.rdbClient.setSchema(schema);
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit, Connection conn, Type type, Duration duration, ChronoUnit unit) {
        String rdbURL;
        String tsIRI = "https://www.theworldavatar.com/kg/ontotimeseries/Timeseries_" + UUID.randomUUID();
        Iri timeseriesType = null;
        if (type.equals((Object)Type.AVERAGE)) {
            timeseriesType = TimeSeriesSparql.AVERAGE_TIMESERIES;
        } else if (type.equals((Object)Type.STEPWISECUMULATIVE)) {
            timeseriesType = TimeSeriesSparql.STEPWISE_CUMULATIVE_TIMESERIES;
        } else if (type.equals((Object)Type.CUMULATIVETOTAL)) {
            timeseriesType = TimeSeriesSparql.CUMULATIVE_TOTAL_TIMESERIES;
        } else if (type.equals((Object)Type.INSTANTANEOUS)) {
            timeseriesType = TimeSeriesSparql.INSTANTANEOUS_TIMESERIES;
        } else if (type.equals((Object)Type.GENERAL)) {
            timeseriesType = TimeSeriesSparql.TIMESERIES;
        }
        try {
            rdbURL = conn.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.warn(e.getMessage());
            LOGGER.warn("Failed to get RDB URL from connection object, setting RDB URL to = \"\"");
            rdbURL = "";
        }
        try {
            this.rdfClient.initTS(tsIRI, dataIRIs, rdbURL, timeUnit, timeseriesType, duration, unit);
        }
        catch (Exception eRdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", eRdfCreate);
        }
        try {
            this.rdbClient.initTimeSeriesTable(dataIRIs, dataClass, tsIRI, conn);
        }
        catch (JPSRuntimeException eRdbCreate) {
            try {
                this.rdfClient.removeTimeSeries(tsIRI);
            }
            catch (Exception eRdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + tsIRI + " , as database related instantiation failed but KG triples were created.", eRdfDelete);
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", eRdbCreate);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Connection conn, List<Type> type, List<Duration> durations, List<ChronoUnit> units) {
        this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, null, conn, type, durations, units);
    }

    private void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid, Connection conn, List<Type> type, List<Duration> durations, List<ChronoUnit> units) {
        String rdbURL;
        ArrayList<String> tsIRIs = new ArrayList<String>(dataIRIs.size());
        ArrayList<Iri> timeSeriesTypes = new ArrayList<Iri>(dataIRIs.size());
        Iri timeSeriesType = null;
        for (int i = 0; i < dataIRIs.size(); ++i) {
            String tsIRI = "https://www.theworldavatar.com/kg/ontotimeseries/Timeseries_" + UUID.randomUUID();
            if (type.get(i).equals((Object)Type.AVERAGE)) {
                timeSeriesType = TimeSeriesSparql.AVERAGE_TIMESERIES;
            } else if (type.get(i).equals((Object)Type.STEPWISECUMULATIVE)) {
                timeSeriesType = TimeSeriesSparql.STEPWISE_CUMULATIVE_TIMESERIES;
            } else if (type.get(i).equals((Object)Type.CUMULATIVETOTAL)) {
                timeSeriesType = TimeSeriesSparql.CUMULATIVE_TOTAL_TIMESERIES;
            } else if (type.get(i).equals((Object)Type.INSTANTANEOUS)) {
                timeSeriesType = TimeSeriesSparql.INSTANTANEOUS_TIMESERIES;
            } else if (type.get(i).equals((Object)Type.GENERAL)) {
                timeSeriesType = TimeSeriesSparql.TIMESERIES;
            }
            tsIRIs.add(i, tsIRI);
            timeSeriesTypes.add(i, timeSeriesType);
        }
        try {
            rdbURL = conn.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.warn(e.getMessage());
            LOGGER.warn("Failed to get RDB URL from connection object, setting RDB URL to = \"\"");
            rdbURL = "";
        }
        ArrayList<String> singleListDataIri = new ArrayList<String>();
        dataIRIs.stream().forEach(dataIRIList -> dataIRIList.stream().forEach(singleListDataIri::add));
        if (this.rdfClient.checkAnyTimeSeriesExists(singleListDataIri)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "One or more of the provided data IRI already has a time series attached. Instantiate them individually with initTimeSeries if needed.");
        }
        try {
            this.rdfClient.bulkInitTS(tsIRIs, dataIRIs, rdbURL, timeUnit, timeSeriesTypes, durations, units);
        }
        catch (Exception eRdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", eRdfCreate);
        }
        ArrayList<List<String>> failedDataIris = new ArrayList<List<String>>(dataIRIs.size());
        for (int i = 0; i < dataIRIs.size(); ++i) {
            try {
                this.rdbClient.initTimeSeriesTable(dataIRIs.get(i), dataClass.get(i), (String)tsIRIs.get(i), srid, conn);
                continue;
            }
            catch (JPSRuntimeException eRdbCreate) {
                try {
                    this.rdfClient.removeTimeSeries((String)tsIRIs.get(i));
                }
                catch (Exception eRdfDelete) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + (String)tsIRIs.get(i) + " , as database related instantiation failed but KG triples were created.");
                }
                failedDataIris.add(dataIRIs.get(i));
            }
        }
        if (!failedDataIris.isEmpty()) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created for the following data IRIs: " + failedDataIris);
        }
    }

    public void addTimeSeriesData(TimeSeries<T> ts, Connection conn) {
        ArrayList tsList = new ArrayList();
        tsList.add(ts);
        this.rdbClient.addTimeSeriesData(tsList, conn);
    }

    public void bulkaddTimeSeriesData(List<TimeSeries<T>> tsList, Connection conn) {
        this.rdbClient.addTimeSeriesData(tsList, conn);
    }

    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound, Connection conn) {
        this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound, conn);
    }

    public void deleteIndividualTimeSeries(String dataIRI, Connection conn) {
        String tsIRI = this.rdfClient.getTimeSeries(dataIRI);
        if (tsIRI == null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " not associated with any timeseries.");
        }
        if (this.rdfClient.getAssociatedData(tsIRI).size() == 1) {
            this.deleteTimeSeries(tsIRI, conn);
        } else {
            try {
                this.rdfClient.removeTimeSeriesAssociation(dataIRI);
            }
            catch (Exception eRdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", eRdfDelete);
            }
            try {
                this.rdbClient.deleteTimeSeries(dataIRI, conn);
            }
            catch (JPSRuntimeException eRdbDelete) {
                try {
                    this.rdfClient.insertTimeSeriesAssociation(dataIRI, tsIRI);
                }
                catch (Exception eRdfCreate) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series association for " + dataIRI + " , as database related deletion failed but KG triples were deleted.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", eRdbDelete);
            }
        }
    }

    public void deleteTimeSeries(String tsIRI, Connection conn) {
        String rdbURL;
        if (!this.rdfClient.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + tsIRI + " does not exist in KG");
        }
        List<String> dataIRIs = this.rdfClient.getAssociatedData(tsIRI);
        String timeUnit = this.rdfClient.getTimeUnit(tsIRI);
        String type = this.rdfClient.getTimeSeriesType(tsIRI);
        Iri timeSeriesType = null;
        if (type.equals("https://www.theworldavatar.com/kg/ontotimeseries/AverageTimeSeries")) {
            timeSeriesType = TimeSeriesSparql.AVERAGE_TIMESERIES;
        } else if (type.equals("https://www.theworldavatar.com/kg/ontotimeseries/InstantaneousTimeSeries")) {
            timeSeriesType = TimeSeriesSparql.INSTANTANEOUS_TIMESERIES;
        } else if (type.equals("https://www.theworldavatar.com/kg/ontotimeseries/StepwiseCumulativeTimeSeries")) {
            timeSeriesType = TimeSeriesSparql.STEPWISE_CUMULATIVE_TIMESERIES;
        } else if (type.equals("https://www.theworldavatar.com/kg/ontotimeseries/CumulativeTotalTimeSeries")) {
            timeSeriesType = TimeSeriesSparql.CUMULATIVE_TOTAL_TIMESERIES;
        } else if (type.equals("https://www.theworldavatar.com/kg/ontotimeseries/TimeSeries")) {
            timeSeriesType = TimeSeriesSparql.TIMESERIES;
        } else {
            throw new JPSRuntimeException(this.exceptionPrefix + "Invalid TimeSeries Type: " + type);
        }
        String temporalUnit = null;
        Double numericDuration = null;
        String durIRI = null;
        if (timeSeriesType.equals(TimeSeriesSparql.AVERAGE_TIMESERIES)) {
            TimeSeriesSparql.CustomDuration customDuration = this.rdfClient.getCustomDuration(tsIRI);
            temporalUnit = customDuration.getUnit();
            numericDuration = customDuration.getValue();
            durIRI = this.rdfClient.getAveragingPeriod(tsIRI);
        }
        try {
            this.rdfClient.removeTimeSeries(tsIRI);
        }
        catch (Exception eRdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", eRdfDelete);
        }
        try {
            rdbURL = conn.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.warn(e.getMessage());
            LOGGER.warn("Failed to get RDB URL from connection object, setting RDB URL to = \"\"");
            rdbURL = "";
        }
        try {
            this.rdbClient.deleteTimeSeriesTable(dataIRIs.get(0), conn);
        }
        catch (JPSRuntimeException eRdbDelete) {
            try {
                this.rdfClient.initTS(tsIRI, dataIRIs, rdbURL, timeUnit, timeSeriesType, durIRI, numericDuration, temporalUnit);
            }
            catch (Exception eRdfCreate) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series " + tsIRI + " , as database related deletion failed but KG triples were deleted.", eRdfCreate);
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", eRdbDelete);
        }
    }

    public void deleteAll(Connection conn) {
        try {
            this.rdfClient.removeAllTimeSeries();
        }
        catch (Exception eRdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from KG! Potentially inconsistent state between KG and database", eRdfDelete);
        }
        try {
            this.rdbClient.deleteAll(conn);
        }
        catch (JPSRuntimeException eRdbDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from database! Potentially inconsistent state between KG and database", eRdbDelete);
        }
    }

    public TimeSeries<T> getLatestData(String dataIRI, Connection conn) {
        return this.rdbClient.getLatestData(dataIRI, conn);
    }

    public TimeSeries<T> getOldestData(String dataIRI, Connection conn) {
        return this.rdbClient.getOldestData(dataIRI, conn);
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound, Connection conn) {
        return this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound, conn);
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRIs, Connection conn) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null, conn);
    }

    public double getAverage(String dataIRI, Connection conn) {
        return this.rdbClient.getAverage(dataIRI, conn);
    }

    public double getMaxValue(String dataIRI, Connection conn) {
        return this.rdbClient.getMaxValue(dataIRI, conn);
    }

    public double getMinValue(String dataIRI, Connection conn) {
        return this.rdbClient.getMinValue(dataIRI, conn);
    }

    public T getMaxTime(String dataIRI, Connection conn) {
        return this.rdbClient.getMaxTime(dataIRI, conn);
    }

    public T getMinTime(String dataIRI, Connection conn) {
        return this.rdbClient.getMinTime(dataIRI, conn);
    }

    public boolean checkTimeSeriesExists(String tsIRI) {
        return this.rdfClient.checkTimeSeriesExists(tsIRI);
    }

    public boolean checkDataHasTimeSeries(String dataIRI, Connection conn) {
        return this.rdbClient.checkDataHasTimeSeries(dataIRI, conn);
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        return this.rdfClient.checkTimeUnitExists(tsIRI);
    }

    public int countTimeSeries() {
        return this.rdfClient.countTS();
    }

    public String getTimeSeriesIRI(String dataIRI) {
        return this.rdfClient.getTimeSeries(dataIRI);
    }

    public String getDbUrl(String tsIRI) {
        return this.rdfClient.getDbUrl(tsIRI);
    }

    public String getTimeUnit(String tsIRI) {
        return this.rdfClient.getTimeUnit(tsIRI);
    }

    public List<String> getAssociatedData(String tsIRI) {
        return this.rdfClient.getAssociatedData(tsIRI);
    }

    public List<String> getAllTimeSeries() {
        return this.rdfClient.getAllTimeSeries();
    }

    public TimeSeriesSparql.CustomDuration getCustomDuration(String tsIRI) {
        return this.rdfClient.getCustomDuration(tsIRI);
    }

    public JSONArray convertToJSON(List<TimeSeries<T>> tsList, List<Integer> id, List<Map<String, String>> unitsMap, List<Map<String, String>> tableHeaderMap) {
        JSONArray tsArray = new JSONArray();
        for (int i = 0; i < tsList.size(); ++i) {
            TimeSeries<T> ts = tsList.get(i);
            JSONObject tsJo = new JSONObject();
            List<String> dataIRIs = ts.getDataIRIs();
            tsJo.put("id", id.get(i));
            if (!ts.getTimes().isEmpty()) {
                if (ts.getTimes().get(0) instanceof Number) {
                    tsJo.put("timeClass", Number.class.getSimpleName());
                } else {
                    tsJo.put("timeClass", ts.getTimes().get(0).getClass().getSimpleName());
                }
            }
            if (tableHeaderMap != null) {
                ArrayList<String> tableHeader = new ArrayList<String>();
                for (String dataIRI : dataIRIs) {
                    tableHeader.add(tableHeaderMap.get(i).get(dataIRI));
                }
                tsJo.put("data", tableHeader);
            } else {
                tsJo.put("data", dataIRIs);
            }
            ArrayList<String> units = new ArrayList<String>();
            for (String dataIRI : dataIRIs) {
                units.add(unitsMap.get(i).get(dataIRI));
            }
            tsJo.put("units", units);
            tsJo.put("time", ts.getTimes());
            JSONArray values = new JSONArray();
            JSONArray valuesClass = new JSONArray();
            for (int j = 0; j < dataIRIs.size(); ++j) {
                List<?> valueslist = ts.getValues(dataIRIs.get(j));
                values.put(valueslist);
                String vClass = "Unknown";
                for (Object value : valueslist) {
                    if (value == null) continue;
                    if (value instanceof Number) {
                        vClass = Number.class.getSimpleName();
                        break;
                    }
                    vClass = value.getClass().getSimpleName();
                    break;
                }
                valuesClass.put(vClass);
            }
            tsJo.put("values", values);
            tsJo.put("valuesClass", valuesClass);
            tsArray.put(tsJo);
        }
        return tsArray;
    }

    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass, String rdbURL, String user, String password) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass, String filepath) throws IOException {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    public TimeSeriesClient(Class<T> timeClass, String filepath) throws IOException {
        RemoteStoreClient kbClient = new RemoteStoreClient();
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.loadSparqlConfigs(filepath);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    private void loadSparqlConfigs(String filepath) throws IOException {
        this.rdfClient.loadSparqlConfigs(filepath);
    }

    private void loadRdbConfigs(String filepath) throws IOException {
        this.rdbClient.loadRdbConfigs(filepath);
    }

    public void setRDBClient(String rdbURL, String user, String password) {
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit, Type type, Duration duration, ChronoUnit unit) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.initTimeSeries(dataIRIs, dataClass, timeUnit, conn, type, duration, unit);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, List<Type> type, List<Duration> durations, List<ChronoUnit> units) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, null, conn, type, durations, units);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid, List<Type> type, List<Duration> durations, List<ChronoUnit> units) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, srid, conn, type, durations, units);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void addTimeSeriesData(TimeSeries<T> ts) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.addTimeSeriesData(ts, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void bulkaddTimeSeriesData(List<TimeSeries<T>> tsList) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.rdbClient.addTimeSeriesData(tsList, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void deleteIndividualTimeSeries(String dataIRI) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.deleteIndividualTimeSeries(dataIRI, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void deleteTimeSeries(String tsIRI) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.deleteTimeSeries(tsIRI, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void deleteAll() {
        try (Connection conn = this.rdbClient.getConnection();){
            this.deleteAll(conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public TimeSeries<T> getLatestData(String dataIRI) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                timeSeries = this.rdbClient.getLatestData(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public TimeSeries<T> getOldestData(String dataIRI) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                timeSeries = this.rdbClient.getOldestData(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                timeSeries = this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRIs) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null);
    }

    public double getAverage(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                d = this.rdbClient.getAverage(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    public double getMaxValue(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                d = this.rdbClient.getMaxValue(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    public double getMinValue(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                d = this.rdbClient.getMinValue(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getMaxTime(String dataIRI) {
        try (Connection conn = this.rdbClient.getConnection();){
            T t = this.rdbClient.getMaxTime(dataIRI, conn);
            return t;
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getMinTime(String dataIRI) {
        try (Connection conn = this.rdbClient.getConnection();){
            T t = this.rdbClient.getMinTime(dataIRI, conn);
            return t;
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        boolean bl;
        block8: {
            Connection conn = this.rdbClient.getConnection();
            try {
                bl = this.rdbClient.checkDataHasTimeSeries(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return bl;
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.initTimeSeries(dataIRIs, dataClass, timeUnit, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit, Connection conn) {
        this.initTimeSeries(dataIRIs, dataClass, timeUnit, conn, Type.GENERAL, null, null);
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Connection conn) {
        this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, null, conn);
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid, Connection conn) {
        ArrayList<Type> types = new ArrayList<Type>(dataIRIs.size());
        for (int i = 0; i < dataIRIs.size(); ++i) {
            types.add(Type.GENERAL);
        }
        this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, srid, conn, types, null, null);
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, null, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid) {
        try (Connection conn = this.rdbClient.getConnection();){
            this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, srid, conn);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public static enum Type {
        AVERAGE,
        STEPWISECUMULATIVE,
        CUMULATIVETOTAL,
        INSTANTANEOUS,
        GENERAL;

    }
}

