/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.fed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import uk.ac.cam.cares.jps.base.query.sparql.PrefixToUrlMap;

public class ParsedQueryTreeVisitor
extends AbstractQueryModelVisitor<RuntimeException> {
    static final Logger LOGGER = LogManager.getLogger(ParsedQueryTreeVisitor.class);
    private static final String BLAZEGRAPH_GEO_PREFIX = PrefixToUrlMap.getPrefixUrl("BLAZEGEO");
    private List<ServiceGraphPatternSummary> summaries = new ArrayList<ServiceGraphPatternSummary>();
    private List<String> allKeys = new ArrayList<String>();
    private List<String> currentKeys = null;
    private Set<String> bindingNames = new HashSet<String>();

    public List<ServiceGraphPatternSummary> getSummariesWithoutBindings() {
        ArrayList<ServiceGraphPatternSummary> result = new ArrayList<ServiceGraphPatternSummary>();
        for (ServiceGraphPatternSummary current : this.summaries) {
            if (this.bindingNames.contains(current.serviceVarName)) continue;
            result.add(current);
        }
        return result;
    }

    @Override
    protected void meetNode(QueryModelNode node) {
        LOGGER.debug("node=" + node.getSignature());
        if (node instanceof Service) {
            this.meetServiceNode((Service)node);
        } else if (node instanceof StatementPattern) {
            this.meetStatementPatternNode((StatementPattern)node);
        } else if (node instanceof BindingSetAssignment) {
            this.meetBindingSetAssignmentNode((BindingSetAssignment)node);
        } else {
            super.meetNode(node);
        }
    }

    protected void meetServiceNode(Service node) {
        String svalue;
        Var serviceRef = node.getServiceRef();
        Value value = serviceRef.getValue();
        String string = svalue = value == null ? null : value.toString();
        if (serviceRef.isAnonymous() && value instanceof SimpleIRI) {
            super.meetNode(node);
            LOGGER.debug("Service node: No keys for data source selection are collected since endpoint IRI is given!");
            return;
        }
        if (svalue != null && svalue.startsWith(BLAZEGRAPH_GEO_PREFIX)) {
            super.meetNode(node);
            LOGGER.debug("Service node: No keys for data source selection are collected since Blazegraph's special geo service was identified!");
            return;
        }
        ServiceGraphPatternSummary summary = new ServiceGraphPatternSummary();
        summary.serviceVarName = node.getServiceRef().getName();
        if (svalue != null) {
            summary.serviceVarValue = svalue;
        }
        this.currentKeys = new ArrayList<String>();
        super.meetNode(node);
        summary.keys = this.currentKeys;
        this.currentKeys = null;
        this.summaries.add(summary);
        LOGGER.debug("The following keys were collected: " + summary.keys);
    }

    private String addKey(Var variable) {
        Value value = variable.getValue();
        if (value != null) {
            String key = value.stringValue();
            if (key.startsWith(BLAZEGRAPH_GEO_PREFIX)) {
                return null;
            }
            this.allKeys.add(key);
            if (this.currentKeys != null) {
                this.currentKeys.add(key);
                return key;
            }
        }
        return null;
    }

    protected void meetStatementPatternNode(StatementPattern node) {
        String key = this.addKey(node.getPredicateVar());
        if (key != null && key == "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") {
            this.addKey(node.getObjectVar());
        }
        super.meetNode(node);
    }

    protected void meetBindingSetAssignmentNode(BindingSetAssignment node) {
        LOGGER.debug("binding names=" + node.getBindingNames());
        this.bindingNames.addAll(node.getBindingNames());
        super.meetNode(node);
    }

    public class ServiceGraphPatternSummary {
        public String serviceVarName = null;
        public String serviceVarValue = null;
        public List<String> keys = null;
    }
}

