/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.sql.SQLException;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.CDL;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;

public class SparqlOverHttpService {
    private RDFStoreType type = RDFStoreType.FUSEKI;
    private String sparqlServiceURIForQuery = null;
    private String sparqlServiceURIForUpdate = null;
    private TripleStoreClientInterface kbClient;

    public SparqlOverHttpService(String datasetUrl) {
        if (datasetUrl.contains("rdf4j")) {
            this.init(RDFStoreType.RDF4J, datasetUrl);
        } else {
            this.init(RDFStoreType.FUSEKI, datasetUrl);
        }
    }

    public SparqlOverHttpService(RDFStoreType rdfStoreType, String datasetUrl) {
        this.init(rdfStoreType, datasetUrl);
    }

    public SparqlOverHttpService(RDFStoreType rdfStoreType, String sparqlServiceURIForQuery, String sparqlServiceURIForUpdate) {
        this.type = rdfStoreType;
        this.sparqlServiceURIForQuery = sparqlServiceURIForQuery;
        this.sparqlServiceURIForUpdate = sparqlServiceURIForUpdate;
    }

    private void init(RDFStoreType rdfStoreType, String datasetUrl) {
        if (RDFStoreType.RDF4J == rdfStoreType) {
            this.type = RDFStoreType.RDF4J;
            this.sparqlServiceURIForQuery = datasetUrl;
            this.sparqlServiceURIForUpdate = datasetUrl + "/statements";
        } else if (RDFStoreType.FUSEKI == rdfStoreType) {
            this.type = RDFStoreType.FUSEKI;
            this.sparqlServiceURIForQuery = datasetUrl + "/query";
            this.sparqlServiceURIForUpdate = datasetUrl + "/update";
        } else if (RDFStoreType.BLAZEGRAPH == rdfStoreType) {
            this.type = RDFStoreType.BLAZEGRAPH;
            this.sparqlServiceURIForQuery = datasetUrl;
            this.sparqlServiceURIForUpdate = datasetUrl + "/update";
        } else {
            throw new JPSRuntimeException("unsupported RDF store type = " + (Object)((Object)rdfStoreType));
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("SparqlOverHttpService[type=").append((Object)this.type);
        b.append(", query url=").append(this.sparqlServiceURIForQuery);
        b.append(", update url=").append(this.sparqlServiceURIForUpdate);
        return b.toString();
    }

    public String executePost(String messageBody) throws SQLException {
        int statusCode;
        CloseableHttpResponse httpResponse;
        URI uri = Http.createURI(this.sparqlServiceURIForUpdate, new String[0]);
        HttpPost request = new HttpPost(uri);
        if (RDFStoreType.RDF4J.equals((Object)this.type)) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            messageBody = "update=" + messageBody;
        } else {
            if (RDFStoreType.BLAZEGRAPH.equals((Object)this.type)) {
                this.kbClient = new RemoteStoreClient();
                if (this.sparqlServiceURIForUpdate == null) {
                    throw new SQLException("SparqlOverHttpService: SPARQL service URI for update is null. Provide a valid URI.");
                }
                if (this.sparqlServiceURIForUpdate.isEmpty()) {
                    throw new SQLException("SparqlOverHttpService: SPARQL service URI for update is emptry. Provide a valid URI.");
                }
                this.kbClient.setUpdateEndpoint(this.sparqlServiceURIForUpdate);
                this.kbClient.setQuery(messageBody);
                int response = this.kbClient.executeUpdate();
                return "" + response;
            }
            request.setHeader("Content-Type", "application/sparql-update");
        }
        try {
            StringEntity entity = new StringEntity(messageBody);
            request.setEntity(entity);
            System.out.println(request);
        }
        catch (UnsupportedEncodingException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        try {
            httpResponse = HttpClientBuilder.create().build().execute(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        String responseBody = null;
        if (httpResponse.getEntity() != null) {
            try {
                responseBody = EntityUtils.toString(httpResponse.getEntity());
            }
            catch (Exception e) {
                throw new JPSRuntimeException(e.getMessage(), e);
            }
        }
        if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
            Header[] headers;
            for (Header current : headers = httpResponse.getAllHeaders()) {
                System.out.println(current.getName() + "=" + current.getValue());
            }
            throw new JPSRuntimeException("HTTP response with error = " + httpResponse.getStatusLine() + "\n" + responseBody);
        }
        return responseBody;
    }

    public String executeGet(String sparqlQuery) throws SQLException {
        CloseableHttpResponse httpResponse;
        URI uri = null;
        if (RDFStoreType.RDF4J.equals((Object)this.type)) {
            uri = Http.createURI(this.sparqlServiceURIForQuery, "query", sparqlQuery, "Accept", MediaType.TEXT_CSV.type);
        } else {
            if (RDFStoreType.BLAZEGRAPH.equals((Object)this.type)) {
                this.kbClient = new RemoteStoreClient();
                if (this.sparqlServiceURIForQuery == null) {
                    throw new SQLException("SparqlOverHttpService: SPARQL service URI for query is null. Provide a valid URI.");
                }
                if (this.sparqlServiceURIForQuery.isEmpty()) {
                    throw new SQLException("SparqlOverHttpService: SPARQL service URI for query is empty. Provide a valid URI.");
                }
                this.kbClient.setQueryEndpoint(this.sparqlServiceURIForQuery);
                this.kbClient.setQuery(sparqlQuery);
                JSONArray jsonArray = this.kbClient.executeQuery();
                if (jsonArray != null) {
                    return CDL.toString(jsonArray);
                }
                return null;
            }
            uri = Http.createURI(this.sparqlServiceURIForQuery, "query", sparqlQuery);
        }
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", MediaType.TEXT_CSV.type);
        try {
            httpResponse = HttpClientBuilder.create().build().execute(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        String responseBody = null;
        if (httpResponse.getEntity() != null) {
            try {
                responseBody = EntityUtils.toString(httpResponse.getEntity());
            }
            catch (Exception e) {
                throw new JPSRuntimeException(e.getMessage(), e);
            }
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            Header[] headers;
            for (Header current : headers = httpResponse.getAllHeaders()) {
                System.out.println(current.getName() + "=" + current.getValue());
            }
            throw new JPSRuntimeException("HTTP response with error = " + httpResponse.getStatusLine() + "\n" + responseBody);
        }
        return responseBody;
    }

    public static enum RDFStoreType {
        FUSEKI,
        RDF4J,
        BLAZEGRAPH,
        OBDA;

    }
}

