/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.query.AccessAgentCaller;

public class RDBAccessAgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(RDBAccessAgentCaller.class);
    public static final String ACCESSAGENT_HOST_NAME = "ACCESSAGENT_HOST";
    public static String accessAgentHost = System.getenv("ACCESSAGENT_HOST");

    public static String getRDBUrl(String targetUrl) {
        LOGGER.info("get url for targetUrl=" + targetUrl);
        Object[] a = RDBAccessAgentCaller.createRDBAccessRequestUrl(targetUrl);
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        return (String)new JSONObject(Http.execute(Http.get(requestUrl, null, joparams))).get("result");
    }

    public static Object[] createRDBAccessRequestUrl(String targetUrl) {
        String requestUrl = RDBAccessAgentCaller.getBaseWorldUrlforRDBAccess(targetUrl);
        JSONObject joparams = new JSONObject();
        joparams.put("targetresourceiri", AccessAgentCaller.cutHashFragment(targetUrl));
        Object[] a = new Object[]{requestUrl, joparams};
        return a;
    }

    public static String getBaseWorldUrlforRDBAccess(String url) {
        URI requestUrl = null;
        try {
            URI uri = new URI(URLDecoder.decode(url, "UTF-8"));
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            if (scheme == null) {
                scheme = "http";
            }
            if (authority == null) {
                authority = accessAgentHost;
            }
            requestUrl = new URI(scheme, authority, "/access-agent/rdbaccess", null, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new JPSRuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e);
        }
        return requestUrl.toString();
    }

    static {
        if (accessAgentHost == null) {
            LOGGER.info("ACCESSAGENT_HOST not found in environment variables... Using jps.properties.");
            accessAgentHost = KeyValueMap.getInstance().get("url.accessagent.host");
        }
        LOGGER.info("Default ACCESSAGENT_HOST set to " + accessAgentHost);
    }
}

