/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.agent;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.agent.JPSAgent;
import uk.ac.cam.cares.jps.base.derivation.Derivation;
import uk.ac.cam.cares.jps.base.derivation.DerivationClient;
import uk.ac.cam.cares.jps.base.derivation.DerivationInputs;
import uk.ac.cam.cares.jps.base.derivation.DerivationOutputs;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.derivation.StatusType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.DerivationAgentInterface;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationAgent
extends JPSAgent
implements DerivationAgentInterface {
    private static final Logger LOGGER = LogManager.getLogger(DerivationAgent.class);
    private static final long serialVersionUID = 1L;
    public StoreClientInterface storeClient;
    public DerivationClient devClient;
    public static final String EMPTY_REQUEST_MSG = "An empty request received by DerivationAgent.";
    public static final String DERIVATION_CLIENT_NOT_INITIALISED = "DerivationClient is not initialised yet. You may want to instantiate DerivationAgent with DerivationAgent(StoreClientInterface, String).";

    public DerivationAgent() {
        LOGGER.info("A new DerivationAgent has been initialised.");
    }

    public DerivationAgent(StoreClientInterface storeClient, String derivationInstanceBaseURL) {
        this.storeClient = storeClient;
        this.devClient = new DerivationClient(storeClient, derivationInstanceBaseURL);
    }

    @Override
    public JSONObject processRequestParameters(JSONObject requestParams) {
        this.checkIfDerivationClientInitialised();
        JSONObject res = new JSONObject();
        if (this.validateInput(requestParams)) {
            String derivationIRI = requestParams.getString("derivation");
            String derivationType = requestParams.getString("derivation_rdftype");
            Boolean syncNewInfoFlag = requestParams.getBoolean("sync_new_info");
            DerivationInputs inputs = new DerivationInputs(requestParams.getJSONObject("agent_input"), derivationIRI);
            LOGGER.info("Received derivation request parameters: " + requestParams);
            DerivationOutputs outputs = new DerivationOutputs();
            outputs.setThisDerivation(derivationIRI);
            outputs.setRetrievedInputsAt(Instant.now().getEpochSecond());
            if (!syncNewInfoFlag.booleanValue()) {
                outputs.setOldEntitiesMap(requestParams.getJSONObject("belongsTo"));
                outputs.setOldEntitiesDownstreamDerivationMap(requestParams.getJSONObject("downstream_derivation"));
            }
            this.processRequestParameters(inputs, outputs);
            if (syncNewInfoFlag.booleanValue()) {
                String agentServiceIRI = requestParams.getString("agent_service_iri");
                this.devClient.writeSyncDerivationNewInfo(outputs.getOutputTriples(), outputs.getNewDerivedIRI(), agentServiceIRI, inputs.getAllIris(), derivationIRI, derivationType, outputs.getRetrievedInputsAt());
                res.put("retrievedInputsAt", outputs.getRetrievedInputsAt());
                res.put("agent_output", outputs.getNewEntitiesJsonMap());
                return res;
            }
            Derivation derivation = new Derivation(derivationIRI, derivationType);
            if (!derivation.isDerivationAsyn() && !derivation.isDerivationWithTimeSeries()) {
                boolean triplesChangedForSure = this.devClient.reconnectNewDerivedIRIs(outputs.getOutputTriples(), outputs.getNewEntitiesDownstreamDerivationMap(), outputs.getThisDerivation(), outputs.getRetrievedInputsAt());
                if (triplesChangedForSure) {
                    res.put("retrievedInputsAt", outputs.getRetrievedInputsAt());
                    res.put("agent_output", outputs.getNewEntitiesJsonMap());
                    LOGGER.info("Derivation update is done in the knowledge graph, returned response: " + res);
                } else {
                    Derivation updated = this.devClient.getDerivation(derivationIRI);
                    res.put("retrievedInputsAt", updated.getTimestamp());
                    res.put("agent_output", updated.getBelongsToMap());
                    LOGGER.info("Unable to determine if the SPARQL update mutated triples, returned latest information in knowledge graph: " + res);
                }
            } else {
                res.put("retrievedInputsAt", outputs.getRetrievedInputsAt());
                LOGGER.info("DerivationWithTimeSeries update is done, returned response: " + res);
            }
        } else {
            res.put("agent_output", EMPTY_REQUEST_MSG);
        }
        return res;
    }

    @Override
    public void processRequestParameters(DerivationInputs derivationInputs, DerivationOutputs derivationOutputs) {
    }

    @Override
    public boolean validateInput(JSONObject requestParams) throws BadRequestException {
        if (requestParams.isEmpty()) {
            LOGGER.warn("RequestParams are empty, throwing BadRequestException...");
            throw new BadRequestException();
        }
        if (!requestParams.has("agent_input")) {
            LOGGER.info(this.getClass().toString() + " agent received an empty request...");
            return false;
        }
        if (!requestParams.has("derivation")) {
            String msg = this.getClass().toString() + " agent received a request that doesn't have derivationIRI...";
            LOGGER.error(msg);
            throw new JPSRuntimeException(msg);
        }
        if (requestParams.getBoolean("sync_new_info")) {
            if (!requestParams.has("agent_service_iri")) {
                String msg = this.getClass().toString() + " agent received a request for sync new information that doesn't have information about agent IRI...";
                LOGGER.error(msg);
                throw new JPSRuntimeException(msg);
            }
        } else {
            if (!requestParams.has("belongsTo")) {
                String msg = this.getClass().toString() + " agent received a request that doesn't have information about old outputs...";
                LOGGER.error(msg);
                throw new JPSRuntimeException(msg);
            }
            if (!requestParams.has("downstream_derivation")) {
                String msg = this.getClass().toString() + " agent received a request that doesn't have information about downstream derivation...";
                LOGGER.error(msg);
                throw new JPSRuntimeException(msg);
            }
        }
        return true;
    }

    @Override
    public void monitorAsyncDerivations(String agentIRI, long periodicalTimescaleInSecond) {
        this.checkIfDerivationClientInitialised();
        long breakOutTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(periodicalTimescaleInSecond);
        boolean queryAgain = false;
        block9: do {
            Map<String, StatusType> derivationsAndStatusType;
            if ((derivationsAndStatusType = this.devClient.getDerivationsAndStatusType(agentIRI)).isEmpty()) {
                LOGGER.info("Currently, no asynchronous derivation <isDerivedUsing> <" + agentIRI + ">.");
            } else {
                LOGGER.info("A list of asynchronous derivations that <isDerivedUsing> <" + agentIRI + "> are retrieved: " + derivationsAndStatusType.toString() + ".");
            }
            for (String derivation : derivationsAndStatusType.keySet()) {
                StatusType statusType = derivationsAndStatusType.get(derivation);
                try {
                    switch (statusType) {
                        case REQUESTED: {
                            Map<String, List<String>> immediateUpstreamDerivationToUpdate = this.devClient.checkImmediateUpstreamDerivation(derivation);
                            if (immediateUpstreamDerivationToUpdate.containsKey(DerivationSparql.ONTODERIVATION_DERIVATIONASYN)) {
                                LOGGER.info("Asynchronous derivation <" + derivation + "> has a list of immediate upstream asynchronous derivations to be updated: " + immediateUpstreamDerivationToUpdate.toString());
                                queryAgain = false;
                                break;
                            }
                            List<String> syncDerivationsToUpdate = this.devClient.groupSyncDerivationsToUpdate(immediateUpstreamDerivationToUpdate);
                            if (!syncDerivationsToUpdate.isEmpty()) {
                                this.devClient.updatePureSyncDerivations(syncDerivationsToUpdate);
                            }
                            if (this.devClient.checkImmediateUpstreamDerivation(derivation).isEmpty()) {
                                JSONObject agentInputs = this.devClient.retrieveAgentInputIRIs(derivation, agentIRI);
                                boolean progressToJob = this.devClient.updateStatusBeforeSetupJob(derivation);
                                if (progressToJob) {
                                    LOGGER.info("Agent <" + agentIRI + "> retrieved inputs of asynchronous derivation <" + derivation + ">: " + agentInputs.toString() + ".");
                                    LOGGER.info("Asynchronous derivation <" + derivation + "> is now in progress.");
                                    DerivationInputs derivationInputs = new DerivationInputs(agentInputs.getJSONObject("agent_input"), derivation);
                                    DerivationOutputs derivationOutputs = new DerivationOutputs();
                                    this.processRequestParameters(derivationInputs, derivationOutputs);
                                    List<String> newDerivedIRI = derivationOutputs.getNewDerivedIRI();
                                    List<TriplePattern> newTriples = derivationOutputs.getOutputTriples();
                                    this.devClient.updateStatusAtJobCompletion(derivation, newDerivedIRI, newTriples);
                                    LOGGER.info("Asynchronous derivation <" + derivation + "> has new generated derived IRI: " + newDerivedIRI.toString() + ".");
                                    LOGGER.info("Asynchronous derivation <" + derivation + "> has all new generated triples: " + newTriples.stream().map(t -> t.getQueryString()).collect(Collectors.toList()));
                                    LOGGER.info("Asynchronous derivation <" + derivation + "> is now finished, to be cleaned up.");
                                } else {
                                    LOGGER.info("Asynchronous derivation <" + derivation + "> is already in progress by another agent thread.");
                                }
                            }
                            queryAgain = true;
                            break;
                        }
                        case INPROGRESS: {
                            queryAgain = false;
                            break;
                        }
                        case FINISHED: {
                            this.devClient.cleanUpFinishedDerivationUpdate(derivation);
                            queryAgain = true;
                            break;
                        }
                        case ERROR: {
                            LOGGER.info("Asynchronous derivation <" + derivation + "> is in Error state.");
                            queryAgain = false;
                            break;
                        }
                        case NOSTATUS: {
                            queryAgain = false;
                        }
                    }
                }
                catch (Exception exc) {
                    this.devClient.markAsError(derivation, exc);
                    queryAgain = true;
                    LOGGER.error("Error when handling derivation <" + derivation + ">", (Throwable)exc);
                }
                if (!queryAgain) continue;
                continue block9;
            }
        } while (System.currentTimeMillis() < breakOutTime && queryAgain);
    }

    public void checkIfDerivationClientInitialised() {
        if (Objects.isNull(this.devClient)) {
            throw new JPSRuntimeException(DERIVATION_CLIENT_NOT_INITIALISED);
        }
    }
}

