/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.compression.CodeWordCoder;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public final class Fast64CodeWordCoder
extends CodeWordCoder {
    private static final long serialVersionUID = 1L;
    private final long[] longCodeWord;
    private final int[] length;

    public Fast64CodeWordCoder(BitVector[] codeWord, long[] longCodeWord) {
        super(codeWord);
        this.longCodeWord = longCodeWord;
        this.length = new int[codeWord.length];
        int i = this.length.length;
        while (i-- != 0) {
            this.length[i] = codeWord[i].size();
        }
    }

    public Fast64CodeWordCoder(BitVector[] codeWord) {
        super(codeWord);
        int i;
        this.longCodeWord = new long[codeWord.length];
        for (i = 0; i < codeWord.length; ++i) {
            long longValue;
            BitVector v = codeWord[i];
            int nbits = v.size();
            this.longCodeWord[i] = longValue = Long.reverse(v.getLong(0L, Math.min(64, nbits)) << 64 - nbits);
        }
        this.length = new int[codeWord.length];
        i = this.length.length;
        while (i-- != 0) {
            this.length[i] = codeWord[i].size();
        }
    }

    @Override
    public int encode(int symbol, OutputBitStream obs) throws IOException {
        return obs.writeLong(this.longCodeWord[symbol], this.length[symbol]);
    }
}

