/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Trunc<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 4291348230758816484L;
    private final Field<T> field;
    private final Field<Integer> decimals;

    Trunc(Field<T> field, Field<Integer> decimals) {
        super(Names.N_TRUNC, field.getDataType());
        this.field = field;
        this.decimals = decimals;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                Integer decimalsVal = Tools.extractVal(this.decimals);
                Field<BigDecimal> power = decimalsVal != null ? DSL.inline(BigDecimal.TEN.pow(decimalsVal, MathContext.DECIMAL128)) : DSL.power(DSL.inline(BigDecimal.TEN), this.decimals);
                ctx.visit(DSL.decode().when(this.field.sign().greaterOrEqual(DSL.zero()), Internal.idiv(Internal.imul(this.field, power).floor(), power)).otherwise(Internal.idiv(Internal.imul(this.field, power).ceil(), power)));
                break;
            }
            case H2: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_TRUNCATE).sql('(').visit(this.field).sql(", ").visit(this.decimals).sql(')');
                break;
            }
            case POSTGRES: {
                ctx.visit(Tools.castIfNeeded(DSL.function("trunc", SQLDataType.NUMERIC, Tools.castIfNeeded(this.field, BigDecimal.class), this.decimals), this.field.getDataType()));
                break;
            }
            default: {
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.field).sql(", ").visit(this.decimals).sql(')');
            }
        }
    }
}

