/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Check;
import org.jooq.Domain;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Meta;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DomainImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.UDTImpl;

final class Snapshot
extends AbstractMeta {
    private static final long serialVersionUID = 5561057000510740144L;
    private Meta delegate;

    Snapshot(Meta meta) {
        super(meta.configuration());
        this.delegate = meta;
        this.getCatalogs();
        this.delegate = null;
        this.resolveReferences();
    }

    private final void resolveReferences() {
        for (Catalog catalog : this.getCatalogs()) {
            ((SnapshotCatalog)catalog).resolveReferences();
        }
    }

    @Override
    final List<Catalog> getCatalogs0() throws DataAccessException {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        for (Catalog catalog : this.delegate.getCatalogs()) {
            result.add(new SnapshotCatalog(catalog));
        }
        return result;
    }

    private class SnapshotUDT<R extends UDTRecord<R>>
    extends UDTImpl<R> {
        private static final long serialVersionUID = -5732449514562314202L;

        SnapshotUDT(SnapshotSchema schema, UDT<R> udt) {
            super(udt.getName(), schema, udt.getPackage(), udt.isSynthetic());
        }
    }

    private class SnapshotSequence<T extends Number>
    extends SequenceImpl<T> {
        private static final long serialVersionUID = -1607062195966296849L;

        SnapshotSequence(SnapshotSchema schema, Sequence<T> sequence) {
            super(sequence.getQualifiedName(), schema, sequence.getDataType(), false, sequence.getStartWith(), sequence.getIncrementBy(), sequence.getMinvalue(), sequence.getMaxvalue(), sequence.getCycle(), sequence.getCache());
        }
    }

    private class SnapshotTable<R extends Record>
    extends TableImpl<R> {
        private static final long serialVersionUID = -6070726881709997500L;
        private final List<Index> indexes;
        private final List<UniqueKey<R>> uniqueKeys;
        private UniqueKey<R> primaryKey;
        private final List<ForeignKey<R, ?>> foreignKeys;
        private final List<Check<R>> checks;

        SnapshotTable(SnapshotSchema schema, Table<R> table) {
            super(table.getQualifiedName(), schema, null, null, table.getCommentPart(), table.getOptions());
            this.indexes = new ArrayList<Index>();
            this.uniqueKeys = new ArrayList<UniqueKey<R>>();
            this.foreignKeys = new ArrayList();
            this.checks = new ArrayList<Check<R>>();
            for (Field<?> field : table.fields()) {
                SnapshotTable.createField(field.getUnqualifiedName(), field.getDataType(), this, field.getComment());
            }
            for (Index index : table.getIndexes()) {
                List<SortField<?>> indexFields = index.getFields();
                SortField[] copiedFields = new SortField[indexFields.size()];
                for (int i = 0; i < indexFields.size(); ++i) {
                    SortField<?> field = indexFields.get(i);
                    Field<?> f = this.field(field.getName());
                    copiedFields[i] = f != null ? f.sort(field.getOrder()) : field;
                }
                this.indexes.add(Internal.createIndex(index.getQualifiedName(), this, copiedFields, index.getUnique()));
            }
            for (UniqueKey uniqueKey : table.getKeys()) {
                this.uniqueKeys.add(Internal.createUniqueKey(this, uniqueKey.getQualifiedName(), this.fields(uniqueKey.getFieldsArray()), uniqueKey.enforced()));
            }
            UniqueKey<R> pk = table.getPrimaryKey();
            for (UniqueKey<R> uk : this.uniqueKeys) {
                if (!uk.equals(pk)) continue;
                this.primaryKey = uk;
            }
            this.foreignKeys.addAll(table.getReferences());
            this.checks.addAll(table.getChecks());
        }

        @Deprecated
        private final TableField<R, ?>[] fields(TableField<R, ?>[] tableFields) {
            TableField[] result = new TableField[tableFields.length];
            for (int i = 0; i < tableFields.length; ++i) {
                result[i] = (TableField)this.field(tableFields[i].getName());
            }
            return result;
        }

        final void resolveReferences() {
            for (int i = 0; i < this.foreignKeys.size(); ++i) {
                ForeignKey<R, ?> fk = this.foreignKeys.get(i);
                UniqueKey<?> uk = Snapshot.this.lookupUniqueKey(fk);
                if (uk == null) {
                    this.foreignKeys.remove(i);
                    continue;
                }
                this.foreignKeys.set(i, AbstractMeta.copyFK(this, uk, fk));
            }
        }

        @Override
        public final List<Index> getIndexes() {
            return Collections.unmodifiableList(this.indexes);
        }

        @Override
        public final List<UniqueKey<R>> getKeys() {
            return Collections.unmodifiableList(this.uniqueKeys);
        }

        @Override
        public final UniqueKey<R> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public final List<ForeignKey<R, ?>> getReferences() {
            return Collections.unmodifiableList(this.foreignKeys);
        }

        @Override
        public final List<Check<R>> getChecks() {
            return Collections.unmodifiableList(this.checks);
        }
    }

    private class SnapshotDomain<T>
    extends DomainImpl<T> {
        private static final long serialVersionUID = -1607062195966296849L;

        SnapshotDomain(SnapshotSchema schema, Domain<T> domain) {
            super(schema, domain.getQualifiedName(), domain.getDataType(), domain.getChecks().toArray(Tools.EMPTY_CHECK));
        }
    }

    private class SnapshotSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -95755926444275258L;
        private final List<SnapshotDomain<?>> domains;
        private final List<SnapshotTable<?>> tables;
        private final List<SnapshotSequence<?>> sequences;
        private final List<SnapshotUDT<?>> udts;

        SnapshotSchema(SnapshotCatalog catalog, Schema schema) {
            super(schema.getQualifiedName(), (Catalog)catalog, schema.getCommentPart());
            this.domains = new ArrayList();
            this.tables = new ArrayList();
            this.sequences = new ArrayList();
            this.udts = new ArrayList();
            for (Domain<?> domain : schema.getDomains()) {
                this.domains.add(new SnapshotDomain(this, domain));
            }
            for (Table table : schema.getTables()) {
                this.tables.add(new SnapshotTable(this, table));
            }
            for (Sequence sequence : schema.getSequences()) {
                this.sequences.add(new SnapshotSequence(this, sequence));
            }
            for (UDT uDT : schema.getUDTs()) {
                this.udts.add(new SnapshotUDT(this, uDT));
            }
        }

        final void resolveReferences() {
            for (SnapshotTable<?> table : this.tables) {
                table.resolveReferences();
            }
        }

        @Override
        public final List<Domain<?>> getDomains() {
            return Collections.unmodifiableList(this.domains);
        }

        @Override
        public final List<Table<?>> getTables() {
            return Collections.unmodifiableList(this.tables);
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public final List<UDT<?>> getUDTs() {
            return Collections.unmodifiableList(this.udts);
        }
    }

    private class SnapshotCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 7979890261252183486L;
        private final List<SnapshotSchema> schemas;

        SnapshotCatalog(Catalog catalog) {
            super(catalog.getQualifiedName(), catalog.getCommentPart());
            this.schemas = new ArrayList<SnapshotSchema>();
            for (Schema schema : catalog.getSchemas()) {
                this.schemas.add(new SnapshotSchema(this, schema));
            }
        }

        private final void resolveReferences() {
            for (SnapshotSchema schema : this.schemas) {
                schema.resolveReferences();
            }
        }

        @Override
        public final List<Schema> getSchemas() {
            return Collections.unmodifiableList(this.schemas);
        }
    }
}

