/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.UUID;
import org.jooq.DataType;
import org.jooq.JSON;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.RowId;
import org.jooq.SQLDialect;
import org.jooq.XML;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDataType;
import org.jooq.types.DayToSecond;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.types.YearToSecond;
import org.jooq.util.cubrid.CUBRIDDataType;
import org.jooq.util.derby.DerbyDataType;
import org.jooq.util.firebird.FirebirdDataType;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.hsqldb.HSQLDBDataType;
import org.jooq.util.mariadb.MariaDBDataType;
import org.jooq.util.mysql.MySQLDataType;
import org.jooq.util.postgres.PostgresDataType;
import org.jooq.util.sqlite.SQLiteDataType;

public final class SQLDataType {
    public static final DataType<String> VARCHAR = new DefaultDataType<String>(null, String.class, "varchar(l)");
    public static final DataType<String> CHAR = new DefaultDataType<String>(null, String.class, "char(l)");
    public static final DataType<String> LONGVARCHAR = new DefaultDataType<String>(null, String.class, "longvarchar(l)");
    public static final DataType<String> CLOB = new DefaultDataType<String>(null, String.class, "clob");
    public static final DataType<String> NVARCHAR = new DefaultDataType<String>(null, String.class, "nvarchar(l)");
    public static final DataType<String> NCHAR = new DefaultDataType<String>(null, String.class, "nchar(l)");
    public static final DataType<String> LONGNVARCHAR = new DefaultDataType<String>(null, String.class, "longnvarchar(l)");
    public static final DataType<String> NCLOB = new DefaultDataType<String>(null, String.class, "nclob");
    public static final DataType<Boolean> BOOLEAN = new DefaultDataType<Boolean>(null, Boolean.class, "boolean");
    public static final DataType<Boolean> BIT = new DefaultDataType<Boolean>(null, Boolean.class, "bit");
    public static final DataType<Byte> TINYINT = new DefaultDataType<Byte>(null, Byte.class, "tinyint");
    public static final DataType<Short> SMALLINT = new DefaultDataType<Short>(null, Short.class, "smallint");
    public static final DataType<Integer> INTEGER = new DefaultDataType<Integer>(null, Integer.class, "integer");
    public static final DataType<Long> BIGINT = new DefaultDataType<Long>(null, Long.class, "bigint");
    public static final DataType<BigInteger> DECIMAL_INTEGER = new DefaultDataType<BigInteger>(null, BigInteger.class, "decimal_integer");
    public static final DataType<UByte> TINYINTUNSIGNED = new DefaultDataType<UByte>(null, UByte.class, "tinyint unsigned");
    public static final DataType<UShort> SMALLINTUNSIGNED = new DefaultDataType<UShort>(null, UShort.class, "smallint unsigned");
    public static final DataType<UInteger> INTEGERUNSIGNED = new DefaultDataType<UInteger>(null, UInteger.class, "integer unsigned");
    public static final DataType<ULong> BIGINTUNSIGNED = new DefaultDataType<ULong>(null, ULong.class, "bigint unsigned");
    public static final DataType<Double> DOUBLE = new DefaultDataType<Double>(null, Double.class, "double");
    public static final DataType<Double> FLOAT = new DefaultDataType<Double>(null, Double.class, "float");
    public static final DataType<Float> REAL = new DefaultDataType<Float>(null, Float.class, "real");
    public static final DataType<BigDecimal> NUMERIC = new DefaultDataType<BigDecimal>(null, BigDecimal.class, "numeric(p, s)");
    public static final DataType<BigDecimal> DECIMAL = new DefaultDataType<BigDecimal>(null, BigDecimal.class, "decimal(p, s)");
    public static final DataType<Date> DATE = new DefaultDataType<Date>(null, Date.class, "date");
    public static final DataType<Timestamp> TIMESTAMP = new DefaultDataType<Timestamp>(null, Timestamp.class, "timestamp(p)");
    public static final DataType<Time> TIME = new DefaultDataType<Time>(null, Time.class, "time(p)");
    public static final DataType<YearToSecond> INTERVAL = new DefaultDataType<YearToSecond>(null, YearToSecond.class, "interval");
    public static final DataType<YearToMonth> INTERVALYEARTOMONTH = new DefaultDataType<YearToMonth>(null, YearToMonth.class, "interval year to month");
    public static final DataType<DayToSecond> INTERVALDAYTOSECOND = new DefaultDataType<DayToSecond>(null, DayToSecond.class, "interval day to second");
    public static final DataType<LocalDate> LOCALDATE = new DefaultDataType<LocalDate>(null, LocalDate.class, "date");
    public static final DataType<LocalTime> LOCALTIME = new DefaultDataType<LocalTime>(null, LocalTime.class, "time(p)");
    public static final DataType<LocalDateTime> LOCALDATETIME = new DefaultDataType<LocalDateTime>(null, LocalDateTime.class, "timestamp(p)");
    public static final DataType<OffsetTime> OFFSETTIME = new DefaultDataType<OffsetTime>(null, OffsetTime.class, "time(p) with time zone");
    public static final DataType<OffsetDateTime> OFFSETDATETIME = new DefaultDataType<OffsetDateTime>(null, OffsetDateTime.class, "timestamp(p) with time zone");
    public static final DataType<OffsetTime> TIMEWITHTIMEZONE = OFFSETTIME;
    public static final DataType<OffsetDateTime> TIMESTAMPWITHTIMEZONE = OFFSETDATETIME;
    public static final DataType<Instant> INSTANT = new DefaultDataType<Instant>(null, Instant.class, "instant");
    public static final DataType<byte[]> BINARY = new DefaultDataType<byte[]>(null, byte[].class, "binary(l)");
    public static final DataType<byte[]> VARBINARY = new DefaultDataType<byte[]>(null, byte[].class, "varbinary(l)");
    public static final DataType<byte[]> LONGVARBINARY = new DefaultDataType<byte[]>(null, byte[].class, "longvarbinary(l)");
    public static final DataType<byte[]> BLOB = new DefaultDataType<byte[]>(null, byte[].class, "blob");
    public static final DataType<Object> OTHER = new DefaultDataType<Object>(null, Object.class, "other");
    public static final DataType<RowId> ROWID = new DefaultDataType<RowId>(null, RowId.class, "rowid");
    public static final DataType<Record> RECORD = new DefaultDataType<Record>(null, Record.class, "record");
    public static final DataType<Result<Record>> RESULT = new DefaultDataType<Result>(null, Result.class, "result");
    public static final DataType<UUID> UUID = new DefaultDataType<UUID>(null, UUID.class, "uuid");
    public static final DataType<JSON> JSON = new DefaultDataType<JSON>(null, JSON.class, "json");
    public static final DataType<JSONB> JSONB = new DefaultDataType<JSONB>(null, JSONB.class, "jsonb");
    public static final DataType<XML> XML = new DefaultDataType<XML>(null, XML.class, "xml");

    public static final DataType<String> VARCHAR(int length) {
        return VARCHAR.length(length);
    }

    public static final DataType<String> CHAR(int length) {
        return CHAR.length(length);
    }

    public static final DataType<String> LONGVARCHAR(int length) {
        return LONGVARCHAR.length(length);
    }

    public static final DataType<String> CLOB(int length) {
        return CLOB.length(length);
    }

    public static final DataType<String> NVARCHAR(int length) {
        return NVARCHAR.length(length);
    }

    public static final DataType<String> NCHAR(int length) {
        return NCHAR.length(length);
    }

    public static final DataType<String> LONGNVARCHAR(int length) {
        return LONGNVARCHAR.length(length);
    }

    public static final DataType<String> NCLOB(int length) {
        return NCLOB.length(length);
    }

    public static final DataType<BigInteger> DECIMAL_INTEGER(int precision) {
        return DECIMAL_INTEGER.precision(precision, 0);
    }

    public static final DataType<BigDecimal> NUMERIC(int precision) {
        return NUMERIC.precision(precision, 0);
    }

    public static final DataType<BigDecimal> NUMERIC(int precision, int scale) {
        return NUMERIC.precision(precision, scale);
    }

    public static final DataType<BigDecimal> DECIMAL(int precision) {
        return DECIMAL.precision(precision, 0);
    }

    public static final DataType<BigDecimal> DECIMAL(int precision, int scale) {
        return DECIMAL.precision(precision, scale);
    }

    public static final DataType<Timestamp> TIMESTAMP(int precision) {
        return TIMESTAMP.precision(precision);
    }

    public static final DataType<Time> TIME(int precision) {
        return TIME.precision(precision);
    }

    public static final DataType<LocalTime> LOCALTIME(int precision) {
        return LOCALTIME.precision(precision);
    }

    public static final DataType<LocalDateTime> LOCALDATETIME(int precision) {
        return LOCALDATETIME.precision(precision);
    }

    public static final DataType<OffsetTime> OFFSETTIME(int precision) {
        return OFFSETTIME.precision(precision);
    }

    public static final DataType<OffsetDateTime> OFFSETDATETIME(int precision) {
        return OFFSETDATETIME.precision(precision);
    }

    public static final DataType<OffsetTime> TIMEWITHTIMEZONE(int precision) {
        return TIMEWITHTIMEZONE.precision(precision);
    }

    public static final DataType<OffsetDateTime> TIMESTAMPWITHTIMEZONE(int precision) {
        return TIMESTAMPWITHTIMEZONE.precision(precision);
    }

    public static final DataType<Instant> INSTANT(int precision) {
        return INSTANT.precision(precision);
    }

    public static final DataType<byte[]> BINARY(int length) {
        return BINARY.length(length);
    }

    public static final DataType<byte[]> VARBINARY(int length) {
        return VARBINARY.length(length);
    }

    public static final DataType<byte[]> LONGVARBINARY(int length) {
        return LONGVARBINARY.length(length);
    }

    public static final DataType<byte[]> BLOB(int length) {
        return BLOB.length(length);
    }

    private static final void initJSR310Types(SQLDialect family) {
        DefaultConfiguration configuration = new DefaultConfiguration(family);
        new DefaultDataType<LocalDate>(family, LOCALDATE, DATE.getTypeName(configuration), DATE.getCastTypeName(configuration));
        new DefaultDataType<LocalTime>(family, LOCALTIME, TIME.getTypeName(configuration), TIME.getCastTypeName(configuration));
        new DefaultDataType<LocalDateTime>(family, LOCALDATETIME, TIMESTAMP.getTypeName(configuration), TIMESTAMP.getCastTypeName(configuration));
    }

    private SQLDataType() {
    }

    static {
        try {
            Class.forName(CUBRIDDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.CUBRID);
            Class.forName(DerbyDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.DERBY);
            Class.forName(FirebirdDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.FIREBIRD);
            Class.forName(H2DataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.H2);
            Class.forName(HSQLDBDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.HSQLDB);
            Class.forName(MariaDBDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.MARIADB);
            Class.forName(MySQLDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.MYSQL);
            Class.forName(PostgresDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.POSTGRES);
            Class.forName(SQLiteDataType.class.getName());
            SQLDataType.initJSR310Types(SQLDialect.SQLITE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

