/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.QuantifiedSelect;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Quantifier;
import org.jooq.impl.Tools;

final class QuantifiedSelectImpl<R extends Record>
extends AbstractQueryPart
implements QuantifiedSelect<R> {
    private static final long serialVersionUID = -1224570388944748450L;
    final Quantifier quantifier;
    final Select<R> query;
    final Field<? extends Object[]> array;
    final Field<?>[] values;

    QuantifiedSelectImpl(Quantifier quantifier, Select<R> query) {
        this.quantifier = quantifier;
        this.query = query;
        this.array = null;
        this.values = null;
    }

    QuantifiedSelectImpl(Quantifier quantifier, Field<? extends Object[]> array) {
        this.quantifier = quantifier;
        this.query = null;
        this.array = array;
        this.values = null;
    }

    QuantifiedSelectImpl(Quantifier quantifier, Field<?> ... values) {
        this.quantifier = quantifier;
        this.query = null;
        this.array = null;
        this.values = values;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean extraParentheses = false;
        ctx.visit(this.quantifier.toKeyword());
        ctx.sql(extraParentheses ? " ((" : " (");
        Tools.visitSubquery(ctx, this.delegate(ctx.configuration()));
        ctx.sql(extraParentheses ? "))" : ")");
    }

    private final QueryPart delegate(Configuration ctx) {
        if (this.query != null) {
            return this.query;
        }
        if (this.values != null) {
            Select<Record1<?>> select = null;
            for (Field<?> value : this.values) {
                select = select == null ? DSL.select(value) : select.unionAll(DSL.select(value));
            }
            return select;
        }
        switch (ctx.family()) {
            case POSTGRES: {
                return this.array;
            }
            case H2: 
            case HSQLDB: {
                return this.create(ctx).select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.array));
            }
        }
        if (this.array instanceof Param) {
            Object[] values0 = (Object[])((Param)this.array).getValue();
            Select<Record1<Object>> select = null;
            for (Object value : values0) {
                select = select == null ? DSL.select(DSL.val(value)) : select.unionAll(DSL.select(DSL.val(value)));
            }
            return select;
        }
        return DSL.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.array));
    }
}

