/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.CaseConditionStep;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractAggregateFunction;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class Product
extends AbstractAggregateFunction<BigDecimal> {
    private static final long serialVersionUID = 1027749554935573353L;

    Product(boolean distinct, Field<?> ... arguments) {
        super(distinct, Names.N_PRODUCT, SQLDataType.NUMERIC, arguments);
    }

    @Override
    public final void accept(Context<?> ctx) {
        final Field<Integer> f = DSL.field("{0}", ((Field)this.arguments.get(0)).getDataType(), new QueryPart[]{this.arguments.get(0)});
        final CaseConditionStep<Integer> negatives = DSL.when(f.lt(DSL.zero()), DSL.inline(-1));
        CustomField<BigDecimal> negativesSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c) {
                c.visit(Product.this.distinct ? DSL.sumDistinct(negatives) : DSL.sum(negatives));
                Product.this.acceptFilterClause(c);
                Product.this.acceptOverClause(c);
            }
        };
        CustomField<BigDecimal> zerosSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c) {
                c.visit(DSL.sum(DSL.choose(f).when((Field<Integer>)DSL.zero(), DSL.one())));
                Product.this.acceptFilterClause(c);
                Product.this.acceptOverClause(c);
            }
        };
        CustomField<BigDecimal> logarithmsSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c) {
                Field<Integer> abs = DSL.abs(DSL.nullif(f, DSL.zero()));
                Field<BigDecimal> ln = DSL.ln(abs);
                c.visit(Product.this.distinct ? DSL.sumDistinct(ln) : DSL.sum(ln));
                Product.this.acceptFilterClause(c);
                Product.this.acceptOverClause(c);
            }
        };
        ctx.visit(Internal.imul(DSL.when(zerosSum.gt(DSL.inline(BigDecimal.ZERO)), DSL.zero()).when(negativesSum.mod(DSL.inline(2)).lt(DSL.inline(BigDecimal.ZERO)), DSL.inline(-1)).otherwise(DSL.one()), DSL.exp((Field<? extends Number>)logarithmsSum)));
    }
}

