/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.krss1.parser.NameResolverStrategy;
import org.semanticweb.owlapi.krss2.parser.JavaCharStream;
import org.semanticweb.owlapi.krss2.parser.KRSS2OWLParserException;
import org.semanticweb.owlapi.krss2.parser.KRSS2ParserConstants;
import org.semanticweb.owlapi.krss2.parser.KRSS2ParserTokenManager;
import org.semanticweb.owlapi.krss2.parser.ParseException;
import org.semanticweb.owlapi.krss2.parser.Provider;
import org.semanticweb.owlapi.krss2.parser.StringProvider;
import org.semanticweb.owlapi.krss2.parser.Token;
import org.semanticweb.owlapi.krss2.parser.TokenMgrException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class KRSS2Parser
implements KRSS2ParserConstants {
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final int[] jj_la1 = new int[32];
    private final JJCalls[] jj_2_rtns = new JJCalls[34];
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    public KRSS2ParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    JavaCharStream jj_input_stream;
    private OWLOntology ontology;
    private OWLDataFactory df;
    private Map<String, IRI> string2IRI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private String base;
    private NameResolverStrategy nameResolution;
    private int adaptiveMaxRuns = 10;
    private boolean alwaysIRIs = false;
    private boolean alwaysNames = false;
    private String[] splitted = new String[2];
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public KRSS2Parser(Provider stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public KRSS2Parser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public KRSS2Parser(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{311296, 0, 0, 0, 311296, 311296, 0, 311296, 311296, 0, 196608, 0, 196608, 0, 196608, 0, 327680, 114688, 0, 0, 49152, 311296, 311296, 311296, 311296, 311296, 49152, 311296, 196608, 0, 49152, 49152};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 524288, 8192, 4096, 0, 0, 256, 0, 0, 131072, 0, 0x2000000, 0, 0x800000, 0, 262144, 0, 0, 49152, 49152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{6, 0, 0, 0, 6, 6, 0, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 0, 6};
    }

    public KRSS2Parser setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.string2IRI = new HashMap<String, IRI>();
        OWLOntologyID id = ontology.getOntologyID();
        this.base = !id.isAnonymous() ? id.getOntologyIRI().toString() + "#" : id.toString() + "#";
        this.nameResolution = NameResolverStrategy.CHECK;
        return this;
    }

    protected void addAxiom(OWLAxiom ax) throws KRSS2OWLParserException {
        try {
            this.ontology.addAxiom(ax);
        }
        catch (OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

    public IRI getIRI(String s) {
        IRI iri = this.string2IRI.get(s);
        if (iri == null) {
            switch (this.nameResolution) {
                case IRI: {
                    iri = IRI.create((String)s);
                    break;
                }
                case NAME: {
                    iri = IRI.create((String)(this.base + s));
                    break;
                }
                case ADAPTIVE: {
                    if (this.adaptiveMaxRuns <= 1) {
                        this.nameResolution = this.alwaysIRIs && !this.alwaysNames ? NameResolverStrategy.IRI : (this.alwaysNames && !this.alwaysIRIs ? NameResolverStrategy.NAME : NameResolverStrategy.CHECK);
                    }
                    --this.adaptiveMaxRuns;
                }
                case CHECK: {
                    String ns = XMLUtils.getNCNamePrefix((CharSequence)s);
                    iri = ns.equals("") ? IRI.create((String)(this.base + s)) : IRI.create((String)s);
                }
            }
            this.string2IRI.put(s, iri);
        }
        return iri;
    }

    public void setNameResolution(NameResolverStrategy nameResolution) {
        this.nameResolution = nameResolution;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    public final void parse() throws ParseException, KRSS2OWLParserException {
        while (this.jj_2_1(2)) {
            this.TBoxStatement();
        }
        if (this.jj_2_2(2)) {
            this.jj_consume_token(20);
        }
        while (this.jj_2_3(2)) {
            this.ABoxStatement();
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(21);
        }
        this.jj_consume_token(0);
    }

    public final void TBoxStatement() throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_5(2)) {
            this.DefinePrimitiveConcept();
        } else if (this.jj_2_6(2)) {
            this.DefineConcept();
        } else if (this.jj_2_7(2)) {
            this.Implies();
        } else if (this.jj_2_8(2)) {
            this.Equivalent();
        } else if (this.jj_2_9(2)) {
            this.Disjoint();
        } else if (this.jj_2_10(2)) {
            this.ComplexRoleInclusion();
        } else if (this.jj_2_11(2)) {
            this.DefinePrimitiveRole();
        } else if (this.jj_2_12(2)) {
            this.DefineRole();
        } else if (this.jj_2_13(2)) {
            this.DisjointRoles();
        } else if (this.jj_2_14(2)) {
            this.RolesEquivalent();
        } else if (this.jj_2_15(2)) {
            this.ImpliesRole();
        } else if (this.jj_2_16(2)) {
            this.Inverses();
        } else if (this.jj_2_17(2)) {
            this.Range();
        } else if (this.jj_2_18(2)) {
            this.Transitive();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void DefinePrimitiveConcept() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression superClass = null;
        this.jj_consume_token(18);
        this.jj_consume_token(24);
        OWLClassExpression subClass = this.ConceptName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 18: 
            case 65: 
            case 66: {
                superClass = this.ConceptExpression();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        if (superClass == null) {
            superClass = this.df.getOWLThing();
        }
        this.addAxiom((OWLAxiom)this.df.getOWLSubClassOfAxiom(subClass, superClass));
    }

    public final void DefineConcept() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(23);
        OWLClassExpression clsA = this.ConceptName();
        OWLClassExpression clsB = this.ConceptExpression();
        this.jj_consume_token(19);
        if (clsB == null) {
            clsB = this.df.getOWLThing();
        }
        this.addAxiom((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(clsA, clsB));
    }

    public final void Disjoint() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(25);
        OWLClassExpression desc1 = this.ConceptExpression();
        OWLClassExpression desc2 = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{desc1, desc2}));
    }

    public final void Equivalent() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(26);
        OWLClassExpression desc1 = this.ConceptExpression();
        OWLClassExpression desc2 = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(desc1, desc2));
    }

    public final void Implies() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(27);
        OWLClassExpression subDescription = this.ConceptExpression();
        OWLClassExpression superDescription = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLSubClassOfAxiom(subDescription, superDescription));
    }

    public final void DefineRole() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(37);
        OWLObjectPropertyExpression propA = this.RoleExpression();
        OWLObjectPropertyExpression propB = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLEquivalentObjectPropertiesAxiom(propA, propB));
    }

    public final void DefinePrimitiveRole() throws ParseException, KRSS2OWLParserException {
        HashSet roles = new HashSet();
        HashSet descs = new HashSet();
        this.jj_consume_token(18);
        this.jj_consume_token(38);
        OWLObjectProperty subProp = this.RoleName();
        this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)subProp));
        this.Parent(subProp);
        this.RightIdentity(subProp);
        this.Parents(subProp);
        this.DomainAttribute(subProp);
        this.RangeAttribute(subProp);
        this.TransitiveAttribute(subProp);
        this.SymmetricAttribute(subProp);
        this.ReflexiveAttribute(subProp);
        this.InverseProperty(subProp);
        this.jj_consume_token(19);
    }

    public final void RightIdentity(OWLObjectProperty r) throws ParseException, KRSS2OWLParserException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                OWLObjectProperty s = this.RoleName();
                this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(Arrays.asList(r, s), (OWLObjectPropertyExpression)r));
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
    }

    public final void LeftIdentity(OWLObjectProperty r) throws ParseException, KRSS2OWLParserException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                OWLObjectProperty s = this.RoleName();
                this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(Arrays.asList(s, r), (OWLObjectPropertyExpression)r));
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
    }

    public final void InverseProperty(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                OWLObjectPropertyExpression superProp = this.RoleExpression();
                this.addAxiom((OWLAxiom)this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)subProp, superProp));
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    public final void DomainAttribute(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: {
                OWLClassExpression desc;
                this.jj_consume_token(40);
                if (this.jj_2_19(2)) {
                    this.jj_consume_token(18);
                    block9: while (true) {
                        if ((desc = this.ConceptExpression()) != null) {
                            descs.add(desc);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 14: 
                            case 15: 
                            case 18: 
                            case 65: 
                            case 66: {
                                continue block9;
                            }
                        }
                        break;
                    }
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(19);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 14: 
                        case 15: 
                        case 18: 
                        case 65: 
                        case 66: {
                            desc = this.ConceptExpression();
                            descs.add(desc);
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                for (OWLClassExpression eachDescription : descs) {
                    this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)subProp, eachDescription));
                }
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
    }

    public final void RangeAttribute(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: {
                OWLClassExpression desc;
                this.jj_consume_token(49);
                if (this.jj_2_20(2)) {
                    this.jj_consume_token(18);
                    block9: while (true) {
                        desc = this.ConceptExpression();
                        descs.add(desc);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 14: 
                            case 15: 
                            case 18: 
                            case 65: 
                            case 66: {
                                continue block9;
                            }
                        }
                        break;
                    }
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(19);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 14: 
                        case 15: 
                        case 18: 
                        case 65: 
                        case 66: {
                            desc = this.ConceptExpression();
                            descs.add(desc);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                for (OWLClassExpression eachDescription : descs) {
                    this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)subProp, eachDescription));
                }
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final void TransitiveAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        this.addAxiom((OWLAxiom)this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)property));
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
    }

    public final void SymmetricAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        this.addAxiom((OWLAxiom)this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)property));
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
    }

    public final void ReflexiveAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        this.addAxiom((OWLAxiom)this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)property));
                        break block0;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
    }

    public final void Parents(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: 
            case 47: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 47: {
                        this.jj_consume_token(47);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 16: {
                                this.jj_consume_token(16);
                                break block0;
                            }
                            case 18: {
                                this.jj_consume_token(18);
                                Set<OWLObjectProperty> roles = this.RoleNameSet();
                                this.jj_consume_token(19);
                                for (OWLObjectProperty prop : roles) {
                                    this.addAxiom((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProp, (OWLObjectPropertyExpression)prop));
                                }
                                break block0;
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 16: {
                                this.jj_consume_token(16);
                                break block0;
                            }
                            case 14: 
                            case 15: 
                            case 65: 
                            case 66: {
                                OWLObjectProperty superProp = this.RoleName();
                                this.addAxiom((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProp, (OWLObjectPropertyExpression)superProp));
                                break block0;
                            }
                        }
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
    }

    public final void Parent(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 65: 
            case 66: {
                OWLObjectProperty superProp = this.RoleName();
                this.addAxiom((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProp, (OWLObjectPropertyExpression)superProp));
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
    }

    public final void DisjointRoles() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(39);
        OWLObjectPropertyExpression exp1 = this.RoleExpression();
        OWLObjectPropertyExpression exp2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLDisjointObjectPropertiesAxiom(new OWLObjectPropertyExpression[]{exp1, exp2}));
    }

    public final void ImpliesRole() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(41);
        OWLObjectPropertyExpression subProp = this.RoleExpression();
        OWLObjectPropertyExpression superProp = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
    }

    public final void Inverses() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(43);
        OWLObjectPropertyExpression prop1 = this.RoleExpression();
        OWLObjectPropertyExpression prop2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLInverseObjectPropertiesAxiom(prop1, prop2));
    }

    public final void RolesEquivalent() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(52);
        OWLObjectPropertyExpression exp1 = this.RoleExpression();
        OWLObjectPropertyExpression exp2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLEquivalentObjectPropertiesAxiom(exp1, exp2));
    }

    public final void ComplexRoleInclusion() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(53);
        List<OWLObjectPropertyExpression> chain = this.propertyChain();
        OWLObjectProperty superProp = this.RoleName();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)superProp));
    }

    public final List<OWLObjectPropertyExpression> propertyChain() throws ParseException, KRSS2OWLParserException {
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        this.jj_consume_token(18);
        this.jj_consume_token(22);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        chain.add(prop);
        if (this.jj_2_21(2)) {
            List<OWLObjectPropertyExpression> subChain = this.propertyChain();
            chain.addAll(subChain);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 18: 
                case 65: 
                case 66: {
                    prop = this.RoleExpression();
                    chain.add(prop);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(19);
        return chain;
    }

    public final void Transitive() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(56);
        OWLObjectProperty prop = this.RoleName();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)prop));
    }

    public final void Range() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(48);
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression rng = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)prop, rng));
    }

    public final OWLClassExpression ConceptExpression() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc;
        if (this.jj_2_22(2)) {
            desc = this.ConceptName();
        } else if (this.jj_2_23(2)) {
            desc = this.And();
        } else if (this.jj_2_24(2)) {
            desc = this.Or();
        } else if (this.jj_2_25(2)) {
            desc = this.Not();
        } else if (this.jj_2_26(2)) {
            desc = this.All();
        } else if (this.jj_2_27(2)) {
            desc = this.Some();
        } else if (this.jj_2_28(2)) {
            desc = this.AtLeast();
        } else if (this.jj_2_29(2)) {
            desc = this.AtMost();
        } else if (this.jj_2_30(2)) {
            desc = this.Exactly();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLClassExpression ConceptName() throws ParseException, KRSS2OWLParserException {
        IRI iri = this.Name();
        return this.df.getOWLClass(iri);
    }

    public final Set<OWLClassExpression> ConceptSet() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        block3: while (true) {
            OWLClassExpression desc = this.ConceptExpression();
            descs.add(desc);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 18: 
                case 65: 
                case 66: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[22] = this.jj_gen;
        return descs;
    }

    public final OWLClassExpression And() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(28);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(19);
        return this.df.getOWLObjectIntersectionOf(operands);
    }

    public final OWLClassExpression Or() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(29);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(19);
        return this.df.getOWLObjectUnionOf(operands);
    }

    public final OWLClassExpression Not() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(30);
        OWLClassExpression operand = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.df.getOWLObjectComplementOf(operand);
    }

    public final OWLClassExpression All() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(31);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.df.getOWLObjectAllValuesFrom(prop, filler);
    }

    public final OWLClassExpression Some() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(33);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.df.getOWLObjectSomeValuesFrom(prop, filler);
    }

    public final OWLClassExpression AtLeast() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(34);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 18: 
            case 65: 
            case 66: {
                filler = this.ConceptExpression();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.df.getOWLObjectMinCardinality(card, prop);
        }
        return this.df.getOWLObjectMinCardinality(card, prop, filler);
    }

    public final OWLClassExpression AtMost() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(35);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 18: 
            case 65: 
            case 66: {
                filler = this.ConceptExpression();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.df.getOWLObjectMaxCardinality(card, prop);
        }
        return this.df.getOWLObjectMaxCardinality(card, prop, filler);
    }

    public final OWLClassExpression Exactly() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(36);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 18: 
            case 65: 
            case 66: {
                filler = this.ConceptExpression();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.df.getOWLObjectExactCardinality(card, prop);
        }
        return this.df.getOWLObjectExactCardinality(card, prop, filler);
    }

    public final OWLObjectProperty RoleName() throws ParseException, KRSS2OWLParserException {
        IRI iri = this.Name();
        return this.df.getOWLObjectProperty(iri);
    }

    public final Set<OWLObjectProperty> RoleNameSet() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        block3: while (true) {
            OWLObjectProperty role = this.RoleName();
            roles.add(role);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 65: 
                case 66: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[26] = this.jj_gen;
        return roles;
    }

    public final OWLObjectPropertyExpression RoleExpression() throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.jj_consume_token(42);
                OWLObjectProperty p = this.RoleName();
                this.jj_consume_token(19);
                exp = this.df.getOWLObjectInverseOf(p);
                break;
            }
            case 14: 
            case 15: 
            case 65: 
            case 66: {
                exp = this.RoleName();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final void ABoxStatement() throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_31(2)) {
            this.Instance();
        } else if (this.jj_2_32(2)) {
            this.Related();
        } else if (this.jj_2_33(2)) {
            this.Equal();
        } else if (this.jj_2_34(2)) {
            this.Distinct();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void Instance() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(61);
        OWLIndividual ind = this.IndividualName();
        OWLClassExpression type = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLClassAssertionAxiom(type, ind));
    }

    public final void Related() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(62);
        OWLIndividual subj = this.IndividualName();
        OWLObjectProperty prop = this.RoleName();
        OWLIndividual obj = this.IndividualName();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)prop, subj, obj));
    }

    public final void Equal() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(60);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLSameIndividualAxiom(new OWLIndividual[]{indA, indB}));
    }

    public final void Distinct() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(18);
        this.jj_consume_token(59);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(19);
        this.addAxiom((OWLAxiom)this.df.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{indA, indB}));
    }

    public final OWLIndividual IndividualName() throws ParseException, KRSS2OWLParserException {
        IRI name = this.Name();
        return this.df.getOWLNamedIndividual(name);
    }

    public final int Integer() throws ParseException, KRSS2OWLParserException {
        Token t = this.jj_consume_token(65);
        return Integer.parseInt(t.image);
    }

    public final boolean parseBoolean() throws ParseException {
        boolean b;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                b = true;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                b = false;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return b;
    }

    public final IRI Name() throws ParseException {
        IRI i;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: 
            case 66: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 66: {
                        t = this.jj_consume_token(66);
                        break;
                    }
                    case 65: {
                        t = this.jj_consume_token(65);
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                i = this.getIRI(t.image);
                break;
            }
            case 14: 
            case 15: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        Token t = this.jj_consume_token(14);
                        i = OWLRDFVocabulary.OWL_THING.getIRI();
                        break block0;
                    }
                    case 15: {
                        Token t = this.jj_consume_token(15);
                        i = OWLRDFVocabulary.OWL_NOTHING.getIRI();
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    private boolean jj_3R_26() {
        return this.jj_3R_40();
    }

    private boolean jj_3_30() {
        return this.jj_3R_34();
    }

    private boolean jj_3_26() {
        return this.jj_3R_30();
    }

    private boolean jj_3_22() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_24()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_25()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_26()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_27()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_28()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_29()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_30()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_34() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_14() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(43);
    }

    private boolean jj_3_33() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(66)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(65)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_23() {
        return this.jj_3R_39();
    }

    private boolean jj_3_32() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_38() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(59);
    }

    private boolean jj_3_20() {
        Token xsp;
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_24());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_37() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(62);
    }

    private boolean jj_3_19() {
        Token xsp;
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_35() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(61);
    }

    private boolean jj_3_15() {
        return this.jj_3R_19();
    }

    private boolean jj_3_11() {
        return this.jj_3R_15();
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_31() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_34()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_11();
    }

    private boolean jj_3_29() {
        return this.jj_3R_33();
    }

    private boolean jj_3_25() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_34() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3_14() {
        return this.jj_3R_18();
    }

    private boolean jj_3_3() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_15() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3_10() {
        return this.jj_3R_14();
    }

    private boolean jj_3_18() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_33() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(37);
    }

    private boolean jj_3_6() {
        return this.jj_3R_10();
    }

    private boolean jj_3_24() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_11() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_28() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_12() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_13() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_13() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_9() {
        return this.jj_3R_13();
    }

    private boolean jj_3_17() {
        return this.jj_3R_21();
    }

    private boolean jj_3_21() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_23() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_27() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private boolean jj_3_12() {
        return this.jj_3R_16();
    }

    private boolean jj_3_16() {
        return this.jj_3R_20();
    }

    private boolean jj_3_8() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3_5() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_8()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_9()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_10()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_11()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_12()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_13()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_14()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_15()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_16()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3_17()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3_18()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[70];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 32; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 70; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : KRSS2ParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 34; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        KRSS2Parser.jj_la1_init_0();
        KRSS2Parser.jj_la1_init_1();
        KRSS2Parser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

