/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntBinaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.AsOWLAnnotationProperty;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AsOWLDataProperty;
import org.semanticweb.owlapi.model.AsOWLDatatype;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import uk.ac.manchester.cs.owl.owlapi.HasIncrementalSignatureGenerationSupport;

public abstract class OWLObjectImpl
implements OWLObject,
Serializable,
HasIncrementalSignatureGenerationSupport {
    protected static final Set<OWLAnnotation> NO_ANNOTATIONS = Collections.emptySet();
    protected static final IntBinaryOperator hashIteration = (a, b) -> a * 37 + b;
    protected static LoadingCache<OWLObjectImpl, Set<OWLEntity>> signatures = Caffeine.newBuilder().weakKeys().softValues().build(key -> key.addSignatureEntitiesToSet(new HashSet<OWLEntity>()));
    protected static LoadingCache<OWLObjectImpl, Set<OWLAnonymousIndividual>> anonCaches = Caffeine.newBuilder().weakKeys().softValues().build(key -> key.addAnonymousIndividualsToSet(new HashSet<OWLAnonymousIndividual>()));
    protected int hashCode = 0;

    static int hash(int start, Stream<?> s) {
        return ((Stream)s.sequential()).mapToInt(OWLObjectImpl::hash).reduce(start, hashIteration);
    }

    private static int hash(Object o) {
        if (o instanceof Stream) {
            return ((Stream)o).mapToInt(Object::hashCode).sum();
        }
        return o.hashCode();
    }

    protected static List<OWLAnnotation> asAnnotations(Collection<OWLAnnotation> anns) {
        if (anns.isEmpty()) {
            return Collections.emptyList();
        }
        if (anns.size() == 1) {
            return Collections.singletonList(anns.iterator().next());
        }
        return CollectionFactory.sortOptionally(anns.stream().distinct());
    }

    protected int hashCode(OWLObject object) {
        return OWLObjectImpl.hash(object.hashIndex(), object.components());
    }

    @Override
    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return ((Set)anonCaches.get((Object)this)).stream();
    }

    @Override
    public Stream<OWLEntity> signature() {
        return ((Set)signatures.get((Object)this)).stream();
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.signature().anyMatch(e -> e.equals(owlEntity));
    }

    @Override
    public Stream<OWLClass> classesInSignature() {
        return this.signature().filter(AsOWLClass::isOWLClass).map(AsOWLClass::asOWLClass);
    }

    @Override
    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.signature().filter(AsOWLDataProperty::isOWLDataProperty).map(AsOWLDataProperty::asOWLDataProperty);
    }

    @Override
    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.signature().filter(AsOWLObjectProperty::isOWLObjectProperty).map(AsOWLObjectProperty::asOWLObjectProperty);
    }

    @Override
    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.signature().filter(AsOWLNamedIndividual::isOWLNamedIndividual).map(AsOWLNamedIndividual::asOWLNamedIndividual);
    }

    @Override
    public Stream<OWLDatatype> datatypesInSignature() {
        return this.signature().filter(AsOWLDatatype::isOWLDatatype).map(AsOWLDatatype::asOWLDatatype);
    }

    @Override
    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.signature().filter(AsOWLAnnotationProperty::isOWLAnnotationProperty).map(AsOWLAnnotationProperty::asOWLAnnotationProperty);
    }

    @Override
    public Stream<OWLClassExpression> nestedClassExpressions() {
        return this.accept(new OWLClassExpressionCollector()).stream();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        if (this.typeIndex() != other.typeIndex()) {
            return false;
        }
        return OWLAPIStreamUtils.equalStreams(this.components(), other.components());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.hashCode(this);
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(@Nullable OWLObject o) {
        OWLAPIPreconditions.checkNotNull(o);
        assert (o != null);
        int diff = Integer.compare(this.typeIndex(), o.typeIndex());
        if (diff != 0) {
            return diff;
        }
        return OWLAPIStreamUtils.compareIterators(this.components().iterator(), o.components().iterator());
    }

    protected int compareAnnotations(List<OWLAnnotation> l1, List<OWLAnnotation> l2) {
        int i;
        for (i = 0; i < l1.size() && i < l2.size(); ++i) {
            int diff = l1.get(i).compareTo(l2.get(i));
            if (diff == 0) continue;
            return diff;
        }
        if (i < l2.size()) {
            return -1;
        }
        if (i < l1.size()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return ToStringRenderer.getRendering(this);
    }
}

