/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderFacetRestriction
extends BaseBuilder<OWLFacetRestriction, BuilderFacetRestriction> {
    @Nullable
    private OWLLiteral literal = null;
    @Nullable
    private OWLFacet facet = null;

    public BuilderFacetRestriction(OWLFacetRestriction expected, OWLDataFactory df) {
        this(df);
        this.withFacet(expected.getFacet()).withLiteral(expected.getFacetValue());
    }

    @Inject
    public BuilderFacetRestriction(OWLDataFactory df) {
        super(df);
    }

    public BuilderFacetRestriction withLiteral(int arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    public BuilderFacetRestriction withLiteral(OWLLiteral arg) {
        this.literal = arg;
        return this;
    }

    public BuilderFacetRestriction withLiteral(double arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    public BuilderFacetRestriction withLiteral(float arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    public BuilderFacetRestriction withFacet(OWLFacet arg) {
        this.facet = arg;
        return this;
    }

    @Override
    public OWLFacetRestriction buildObject() {
        return this.df.getOWLFacetRestriction(this.getFacet(), this.getLiteral());
    }

    public OWLFacet getFacet() {
        return OWLAPIPreconditions.verifyNotNull(this.facet);
    }

    public OWLLiteral getLiteral() {
        return OWLAPIPreconditions.verifyNotNull(this.literal);
    }
}

