/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class InferredSubObjectPropertyAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLSubObjectPropertyOfAxiom> {
    @Override
    protected void addAxioms(OWLObjectProperty entity, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLSubObjectPropertyOfAxiom> result, Set<OWLObjectPropertyExpression> nonSimpleProperties) {
        OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        reasoner.getSuperObjectProperties((OWLObjectPropertyExpression)entity, true).entities().forEach(p -> this.addIfSimple((OWLObjectPropertyExpression)p, entity, dataFactory, result, nonSimpleProperties, reasoner));
    }

    protected void addIfSimple(OWLObjectPropertyExpression p, OWLObjectProperty entity, OWLDataFactory dataFactory, Set<OWLSubObjectPropertyOfAxiom> result, Set<OWLObjectPropertyExpression> nonSimpleProperties, OWLReasoner reasoner) {
        boolean nonSimple = false;
        boolean inverse = false;
        if (!this.simple(nonSimpleProperties, entity)) {
            nonSimple = true;
        }
        if (p.isAnonymous() && EntitySearcher.isTransitive(p.getInverseProperty(), reasoner.getRootOntology())) {
            inverse = true;
        }
        if (!nonSimple || !inverse) {
            result.add(dataFactory.getOWLSubObjectPropertyOfAxiom(entity, p));
        }
    }

    @Override
    public String getLabel() {
        return "Sub object properties";
    }
}

