/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class RDFXMLWriter {
    private static final IRI RDF_RDF = IRI.create(Namespaces.RDF.getPrefixIRI(), "RDF");
    private static final IRI RDF_RESOURCE = IRI.create(Namespaces.RDF.getPrefixIRI(), "resource");
    private static final String XML_LANG = "xml:lang";
    private static final IRI RDF_NODEID = IRI.create(Namespaces.RDF.getPrefixIRI(), "nodeID");
    private static final IRI RDF_ABOUT = IRI.create(Namespaces.RDF.getPrefixIRI(), "about");
    private static final IRI RDF_DATATYPE = IRI.create(Namespaces.RDF.getPrefixIRI(), "datatype");
    private static final IRI PARSETYPE_IRI = IRI.create(Namespaces.RDF.getPrefixIRI(), "parseType");
    private final XMLWriter writer;

    protected RDFXMLWriter(XMLWriter writer) {
        this.writer = OWLAPIPreconditions.checkNotNull(writer, "writer cannot be null");
    }

    public void writeStartElement(IRI elementName) {
        this.writer.writeStartElement(OWLAPIPreconditions.checkNotNull(elementName, "elementName cannot be null"));
    }

    public void writeParseTypeAttribute() {
        this.writer.writeAttribute(PARSETYPE_IRI, "Collection");
    }

    public void writeParseTypeLiteralAttribute() {
        this.writer.writeAttribute(PARSETYPE_IRI, "Literal");
    }

    public void writeDatatypeAttribute(IRI datatypeIRI) {
        OWLAPIPreconditions.checkNotNull(datatypeIRI, "datatypeIRI cannot be null");
        if (OWL2Datatype.RDF_XML_LITERAL.getIRI().equals(datatypeIRI)) {
            this.writeParseTypeLiteralAttribute();
        } else {
            this.writer.writeAttribute(RDF_DATATYPE, datatypeIRI.toString());
        }
    }

    public void writeTextContent(String text) {
        this.writer.writeTextContent(text);
    }

    public void writeLangAttribute(String lang) {
        this.writer.writeAttribute(XML_LANG, lang);
    }

    public void writeEndElement() {
        this.writer.writeEndElement();
    }

    public void writeAboutAttribute(IRI value) {
        this.writeAttribute(RDF_ABOUT, value);
    }

    public void writeNodeIDAttribute(RDFResource node) {
        this.writer.writeAttribute(RDF_NODEID, node.toString());
    }

    public void writeAttribute(IRI attributeName, IRI value) {
        this.writer.writeAttribute(attributeName, OWLAPIPreconditions.checkNotNull(value, "value cannot be null").toString());
    }

    public void writeOWLObject(OWLObject owlObject) {
    }

    public void writeResourceAttribute(IRI value) {
        this.writeAttribute(RDF_RESOURCE, value);
    }

    public void startDocument() {
        this.writer.startDocument(RDF_RDF);
    }

    public void endDocument() {
        this.writer.endDocument();
    }

    public void writeComment(String comment) {
        this.writer.writeComment(comment);
    }
}

