/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasLang;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public interface OWLLiteral
extends OWLObject,
OWLAnnotationObject,
OWLAnnotationValue,
OWLPropertyAssertionObject,
OWLPrimitive,
HasLang {
    @Override
    default public Stream<?> components() {
        return Stream.of(this.getDatatype(), this.getLiteral(), this.getLang());
    }

    @Override
    default public int hashIndex() {
        return 277;
    }

    @Override
    default public int typeIndex() {
        return 4008;
    }

    default public boolean isRDFPlainLiteral() {
        return false;
    }

    public String getLiteral();

    @Override
    default public String getLang() {
        return "";
    }

    public OWLDatatype getDatatype();

    default public boolean hasLang() {
        return false;
    }

    default public boolean hasLang(@Nullable String lang) {
        return false;
    }

    default public boolean isInteger() {
        return false;
    }

    default public int parseInteger() {
        throw new NumberFormatException(this.getClass().getName() + " does not have an int value but has " + this.getLiteral());
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean parseBoolean() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a boolean value but has " + this.getLiteral());
    }

    default public boolean isDouble() {
        return false;
    }

    default public double parseDouble() {
        throw new NumberFormatException(this.getClass().getName() + " does not have a double value but has " + this.getLiteral());
    }

    default public boolean isFloat() {
        return false;
    }

    default public float parseFloat() {
        throw new NumberFormatException(this.getClass().getName() + " does not have a float value but has " + this.getLiteral());
    }

    @Override
    default public Optional<OWLLiteral> asLiteral() {
        return OWLAPIPreconditions.optional(this);
    }

    default public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    default public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

