/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

public class XZStreamDocumentSource
extends OWLOntologyDocumentSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(XZStreamDocumentSource.class);
    @Nullable
    private byte[] buffer;

    public XZStreamDocumentSource(InputStream is) {
        super("xzinputstream:ontology", null, null);
        this.readIntoBuffer(is);
    }

    public XZStreamDocumentSource(InputStream stream, IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(documentIRI, format, mime);
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream reader) {
        try {
            this.buffer = IOUtils.toByteArray((InputStream)reader);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public Optional<InputStream> getInputStream() {
        if (this.buffer == null) {
            return OWLAPIPreconditions.emptyOptional();
        }
        try {
            return OWLAPIPreconditions.optional(new XZInputStream((InputStream)new ByteArrayInputStream(this.buffer)));
        }
        catch (IOException e) {
            LOGGER.error("Buffer cannot be opened", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }

    @Override
    public Optional<Reader> getReader() {
        try {
            Optional<InputStream> inputStream = this.getInputStream();
            if (!inputStream.isPresent()) {
                return OWLAPIPreconditions.emptyOptional();
            }
            return OWLAPIPreconditions.optional(new InputStreamReader(inputStream.get(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Buffer cannot be opened", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

