/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.structures;

import java.io.Serializable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;

public class SubQuery
implements Serializable {
    private static final long serialVersionUID = 8968907794785828994L;
    protected final Resource subj;
    protected final IRI pred;
    protected final Value obj;

    public SubQuery(Resource subj, IRI pred, Value obj) {
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
    }

    public SubQuery(StatementPattern stmt) {
        this((Resource)stmt.getSubjectVar().getValue(), (IRI)stmt.getPredicateVar().getValue(), stmt.getObjectVar().getValue());
    }

    public boolean isUnbound() {
        return this.subj == null && this.pred == null && this.obj == null;
    }

    public Resource subject() {
        return this.subj;
    }

    public IRI predicate() {
        return this.pred;
    }

    public Value object() {
        return this.obj;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
        result = 31 * result + (this.pred == null ? 0 : this.pred.hashCode());
        result = 31 * result + (this.subj == null ? 0 : this.subj.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubQuery other = (SubQuery)obj;
        if (this.obj == null ? other.obj != null : !this.obj.equals(other.obj)) {
            return false;
        }
        if (this.pred == null ? other.pred != null : !this.pred.equals((Object)other.pred)) {
            return false;
        }
        return !(this.subj == null ? other.subj != null : !this.subj.equals(other.subj));
    }
}

