/*
 * Decompiled with CFR 0.152.
 */
package org.cts.datum;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cts.Identifier;
import org.cts.cs.GeographicExtent;
import org.cts.datum.AbstractDatum;
import org.cts.datum.Datum;
import org.cts.datum.Ellipsoid;
import org.cts.datum.PrimeMeridian;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.Geographic2Geocentric;
import org.cts.op.Identity;
import org.cts.op.LongitudeRotation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.GeoTransformation;
import org.cts.op.transformation.GeocentricTransformation;
import org.cts.op.transformation.GeocentricTransformationSequence;
import org.cts.op.transformation.GeocentricTranslation;
import org.cts.op.transformation.SevenParameterTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeodeticDatum
extends AbstractDatum {
    private static final Map<Object, GeodeticDatum> knownDatumMap = new HashMap<Object, GeodeticDatum>();
    private static final Set<GeodeticDatum> knownDatum = new HashSet<GeodeticDatum>();
    private final Map<GeodeticDatum, Set<GeocentricTransformation>> geocentricTransformations = new HashMap<GeodeticDatum, Set<GeocentricTransformation>>();
    private final Map<GeodeticDatum, Set<CoordinateOperation>> geographicTransformations = new HashMap<GeodeticDatum, Set<CoordinateOperation>>();
    private final Map<Datum, Set<CoordinateOperation>> heightTransformations = new HashMap<Datum, Set<CoordinateOperation>>();
    private final PrimeMeridian primeMeridian;
    private final Ellipsoid ellipsoid;
    private GeocentricTransformation toWGS84;
    public static final GeodeticDatum WGS84 = new GeodeticDatum(new Identifier("EPSG", "6326", "World Geodetic System 1984", "WGS 84"), PrimeMeridian.GREENWICH, Ellipsoid.WGS84, Identity.IDENTITY, GeographicExtent.WORLD, null, null);
    public static final GeodeticDatum NTF_PARIS = new GeodeticDatum(new Identifier("EPSG", "6807", "Nouvelle Triangulation Fran\u00e7aise (Paris)", "NTF (Paris)"), PrimeMeridian.PARIS, Ellipsoid.CLARKE1880IGN, new GeocentricTranslation(-168.0, -60.0, 320.0, 1.0), GeographicExtent.WORLD, "Fundamental point: Pantheon. Latitude: 48 deg 50 min 46.52 sec N; Longitude: 2 deg 20 min 48.67 sec E (of Greenwich).", "1895");
    public static final GeodeticDatum NTF = new GeodeticDatum(new Identifier("EPSG", "6275", "Nouvelle Triangulation Fran\u00e7aise", "NTF"), PrimeMeridian.GREENWICH, Ellipsoid.CLARKE1880IGN, new GeocentricTranslation(-168.0, -60.0, 320.0, 1.0), GeographicExtent.WORLD, "Fundamental point: Pantheon. Latitude: 48 deg 50 min 46.522 sec N; Longitude: 2 deg 20 min 48.667 sec E (of Greenwich).", "1898");
    public static final GeodeticDatum RGF93 = new GeodeticDatum(new Identifier("EPSG", "6171", "R\u00e9seau g\u00e9od\u00e9sique fran\u00e7ais 1993", "RGF93"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, Identity.IDENTITY, GeographicExtent.WORLD, "Coincident with ETRS89 at epoch 1993.0", "1993");
    public static final GeodeticDatum ED50 = new GeodeticDatum(new Identifier("EPSG", "6230", "European Datum 1950", "ED50"), PrimeMeridian.GREENWICH, Ellipsoid.INTERNATIONAL1924, new GeocentricTranslation(-84.0, -97.0, -117.0, 1.0), GeographicExtent.WORLD, "Fundamental point: Potsdam (Helmert Tower). Latitude: 52 deg 22 min 51.4456 sec N; Longitude: 13 deg  3 min 58.9283 sec E (of Greenwich).", "1950");
    public static final GeodeticDatum WGS84GUAD = new GeodeticDatum(new Identifier(GeodeticDatum.class, "Guadeloupe : WGS84", "WGS84GUAD"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, SevenParameterTransformation.createBursaWolfTransformation(1.2239, 2.4156, -1.7598, 0.038, -0.16101, -0.04925, 0.2387), new GeographicExtent("Guadeloupe", 15.875, 16.625, -61.85, -61.075), "", "");
    public static final GeodeticDatum WGS84MART = new GeodeticDatum(new Identifier(GeodeticDatum.class, "Martinique : WGS84", "WGS84GUAD"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, SevenParameterTransformation.createBursaWolfTransformation(0.7696, -0.8692, -12.0631, -0.32511, -0.21041, -0.0239, 0.2829), new GeographicExtent("Martinique", 14.25, 15.025, -61.25, -60.725), "", "");
    public static final GeodeticDatum WGS84SBSM = new GeodeticDatum(new Identifier(GeodeticDatum.class, "St-Martin St-Barth : WGS84", "WGS84SBSM"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, SevenParameterTransformation.createBursaWolfTransformation(14.6642, 5.2493, 0.1981, -0.06838, 0.09141, -0.58131, -0.4067), new GeographicExtent("St-Martin St-Barth", 17.8, 18.2, -63.2, -62.5), "", "");
    public static final GeodeticDatum NAD27 = new GeodeticDatum(new Identifier("EPSG", "6267", "North American Datum 1927", "NAD27"), PrimeMeridian.GREENWICH, Ellipsoid.CLARKE1866, null, GeographicExtent.WORLD, "", "1927");
    public static final GeodeticDatum NAD83 = new GeodeticDatum(new Identifier("EPSG", "6269", "North American Datum 1983", "NAD83"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, null, GeographicExtent.WORLD, "", "1983");

    public static GeodeticDatum createGeodeticDatum(PrimeMeridian primeMeridian, Ellipsoid ellipsoid, GeocentricTransformation toWGS84) {
        GeodeticDatum gd = GeodeticDatum.createGeodeticDatum(new Identifier(GeodeticDatum.class), primeMeridian, ellipsoid, toWGS84, GeographicExtent.WORLD, "", "");
        gd.setDefaultToWGS84Operation(toWGS84);
        if (knownDatumMap.containsKey(gd)) {
            return knownDatumMap.get(gd);
        }
        knownDatumMap.put(gd.getIdentifier(), gd);
        knownDatum.add(gd);
        return gd;
    }

    private GeodeticDatum(Identifier identifier, PrimeMeridian primeMeridian, Ellipsoid ellipsoid, GeocentricTransformation toWGS84, GeographicExtent extent, String origin, String epoch) {
        super(identifier, extent, origin, epoch);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        this.toWGS84 = toWGS84;
        knownDatumMap.put(this.getIdentifier(), this);
        knownDatum.add(this);
    }

    public static GeodeticDatum createGeodeticDatum(Identifier identifier, PrimeMeridian primeMeridian, Ellipsoid ellipsoid, GeocentricTransformation toWGS84, GeographicExtent extent, String origin, String epoch) {
        if (knownDatumMap.containsKey(identifier)) {
            return knownDatumMap.get(identifier);
        }
        if (knownDatumMap.containsKey(identifier.getCode())) {
            return knownDatumMap.get(identifier.getCode());
        }
        if (knownDatumMap.containsKey(identifier.getName())) {
            return knownDatumMap.get(identifier.getName());
        }
        return new GeodeticDatum(identifier, primeMeridian, ellipsoid, toWGS84, extent, origin, epoch);
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public final void setDefaultToWGS84Operation(GeocentricTransformation toWGS84) {
        this.toWGS84 = toWGS84;
        this.addGeocentricTransformation(WGS84, toWGS84, true);
    }

    public Set<GeodeticDatum> getTargetDatum() {
        return this.geographicTransformations.keySet();
    }

    public void addGeocentricTransformation(GeodeticDatum targetDatum, GeocentricTransformation coordOp) {
        this.addGeocentricTransformation(targetDatum, coordOp, true);
    }

    private void addGeocentricTransformation(GeodeticDatum targetDatum, GeocentricTransformation coordOp, boolean addInverseOp) {
        boolean added = false;
        if (this.geocentricTransformations.get(targetDatum) == null) {
            this.geocentricTransformations.put(targetDatum, new HashSet());
        }
        added = this.geocentricTransformations.get(targetDatum).add(coordOp);
        try {
            if (addInverseOp) {
                targetDatum.addGeocentricTransformation(this, coordOp.inverse(), false);
            }
        }
        catch (NonInvertibleOperationException e) {
            e.printStackTrace();
        }
        if (!added) {
            return;
        }
        if (this.geographicTransformations.get(targetDatum) == null) {
            this.geographicTransformations.put(targetDatum, new HashSet());
        }
        try {
            CoordinateOperationSequence cos = null;
            cos = coordOp.isIdentity() && this.getEllipsoid().equals(targetDatum.getEllipsoid()) ? new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, "Geographic Transformation from " + this.getShortName() + " to " + targetDatum.getShortName()), new LongitudeRotation(this.primeMeridian.getLongitudeFromGreenwichInRadians()), new LongitudeRotation(targetDatum.getPrimeMeridian().getLongitudeFromGreenwichInRadians()).inverse()) : new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, "Geographic Transformation from " + this.getShortName() + " to " + targetDatum.getShortName()), new LongitudeRotation(this.primeMeridian.getLongitudeFromGreenwichInRadians()), new Geographic2Geocentric(this.ellipsoid), coordOp, new Geocentric2Geographic(targetDatum.getEllipsoid()), new LongitudeRotation(targetDatum.getPrimeMeridian().getLongitudeFromGreenwichInRadians()).inverse());
            this.geographicTransformations.get(targetDatum).add(cos);
        }
        catch (NonInvertibleOperationException e) {
            e.printStackTrace();
        }
    }

    public void addGeographicTransformation(GeodeticDatum targetDatum, CoordinateOperation coordOp) {
        this.addGeographicTransformation(targetDatum, coordOp, true);
    }

    private void addGeographicTransformation(GeodeticDatum targetDatum, CoordinateOperation coordOp, boolean addInverseOp) {
        if (this.geographicTransformations.get(targetDatum) == null) {
            this.geographicTransformations.put(targetDatum, new HashSet());
        } else if (this.geographicTransformations.get(targetDatum).contains(coordOp)) {
            return;
        }
        this.geographicTransformations.get(targetDatum).add(coordOp);
        if (addInverseOp) {
            try {
                targetDatum.addGeographicTransformation(this, coordOp.inverse(), false);
            }
            catch (NonInvertibleOperationException e) {
                e.printStackTrace();
            }
        }
    }

    public Set<GeocentricTransformation> getGeocentricTransformations(GeodeticDatum targetDatum) {
        if (this.geocentricTransformations.get(targetDatum) == null) {
            this.geocentricTransformations.put(targetDatum, new HashSet());
        }
        if (targetDatum.equals(WGS84) && this.getToWGS84() != null) {
            this.addGeocentricTransformation(targetDatum, this.getToWGS84(), true);
        } else if (this.equals(WGS84) && targetDatum.getToWGS84() != null) {
            try {
                this.addGeocentricTransformation(targetDatum, targetDatum.getToWGS84().inverse(), true);
            }
            catch (NonInvertibleOperationException nonInvertibleOperationException) {}
        } else if (!this.getGeocentricTransformations(WGS84).isEmpty() && !targetDatum.getGeocentricTransformations(WGS84).isEmpty()) {
            try {
                for (GeocentricTransformation op1 : this.getGeocentricTransformations(WGS84)) {
                    for (GeocentricTransformation op2 : targetDatum.getGeocentricTransformations(WGS84)) {
                        if (op1.equals(op2) || op1.isIdentity() && op2.isIdentity()) {
                            this.addGeocentricTransformation(targetDatum, Identity.IDENTITY, true);
                            continue;
                        }
                        if (op1.isIdentity()) {
                            this.addGeocentricTransformation(targetDatum, op2.inverse(), true);
                            continue;
                        }
                        if (op2.isIdentity()) {
                            this.addGeocentricTransformation(targetDatum, op1, true);
                            continue;
                        }
                        this.addGeocentricTransformation(targetDatum, new GeocentricTransformationSequence(new Identifier(CoordinateOperation.class), op1, op2.inverse()), true);
                    }
                }
            }
            catch (NonInvertibleOperationException nonInvertibleOperationException) {
                // empty catch block
            }
        }
        return this.geocentricTransformations.get(targetDatum);
    }

    public Set<CoordinateOperation> getGeographicTransformations(GeodeticDatum targetDatum) {
        this.getGeocentricTransformations(targetDatum);
        Set<CoordinateOperation> ops = this.geographicTransformations.get(targetDatum);
        if (ops == null) {
            this.geographicTransformations.put(targetDatum, new HashSet());
        }
        if (!(this.equals(WGS84) || targetDatum.equals(WGS84) || this.getGeographicTransformations(WGS84).isEmpty() || targetDatum.getGeographicTransformations(WGS84).isEmpty())) {
            try {
                for (CoordinateOperation op1 : this.getGeographicTransformations(WGS84)) {
                    for (CoordinateOperation op2 : targetDatum.getGeographicTransformations(WGS84)) {
                        if (op1.equals(op2) || op1.isIdentity() && op2.isIdentity()) {
                            this.addGeographicTransformation(targetDatum, Identity.IDENTITY, true);
                            continue;
                        }
                        this.addGeographicTransformation(targetDatum, new GeocentricTransformationSequence(new Identifier(CoordinateOperation.class), op1, op2.inverse()), true);
                    }
                }
            }
            catch (NonInvertibleOperationException nonInvertibleOperationException) {
                // empty catch block
            }
        }
        return this.geographicTransformations.get(targetDatum);
    }

    public Set<CoordinateOperation> getHeightTransformations(Datum datum) {
        return this.heightTransformations.get(datum);
    }

    @Override
    public GeocentricTransformation getToWGS84() {
        return this.toWGS84;
    }

    public static GeodeticDatum getGeodeticDatum(Object id) {
        return knownDatumMap.get(id);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("DATUM[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getEllipsoid().toWKT());
        GeocentricTransformation towgs84 = this.getToWGS84();
        if (towgs84 != null && towgs84 instanceof GeoTransformation) {
            GeoTransformation geoTransformation = (GeoTransformation)((Object)towgs84);
            w.append(geoTransformation.toWKT());
        } else if (towgs84 instanceof Identity) {
            w.append(",TOWGS84[0,0,0,0,0,0,0]");
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    @Override
    public String toString() {
        return this.getIdentifier().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeodeticDatum) {
            boolean toWGS84Equality;
            GeodeticDatum gd = (GeodeticDatum)o;
            if (this.getIdentifier().equals(gd.getIdentifier())) {
                return true;
            }
            if (this.getToWGS84() == null || gd.toWGS84 == null) {
                toWGS84Equality = false;
            } else {
                boolean bl = toWGS84Equality = this.getToWGS84().equals(gd.getToWGS84()) || this.getToWGS84().isIdentity() && gd.getToWGS84().isIdentity();
            }
            boolean extentEquality = this.getExtent() == null ? gd.getExtent() == null : this.getExtent().equals(gd.getExtent());
            extentEquality = this.getExtent() == null ? gd.getExtent() == null : this.getExtent().equals(gd.getExtent());
            return this.ellipsoid.equals(gd.getEllipsoid()) && this.primeMeridian.equals(gd.getPrimeMeridian()) && toWGS84Equality && extentEquality;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.primeMeridian != null ? this.primeMeridian.hashCode() : 0);
        hash = 83 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        hash = 83 * hash + (this.toWGS84 != null ? this.toWGS84.hashCode() : 0);
        return hash;
    }

    public void removeAllTransformations() {
        for (GeodeticDatum gd : this.geocentricTransformations.keySet()) {
            gd.geocentricTransformations.remove(this);
        }
        for (GeodeticDatum gd : this.geographicTransformations.keySet()) {
            gd.geographicTransformations.remove(this);
        }
        this.geocentricTransformations.clear();
        this.geographicTransformations.clear();
    }

    static {
        knownDatumMap.put("wgs84", WGS84);
        knownDatumMap.put("ntfparis", NTF_PARIS);
        knownDatumMap.put("ntf", NTF);
        knownDatumMap.put("rgf93", RGF93);
        knownDatumMap.put("ed50", ED50);
        knownDatumMap.put("nad27", NAD27);
        knownDatumMap.put("nad83", NAD83);
    }
}

