/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cts.CRSHelper;
import org.cts.Identifiable;
import org.cts.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifiableComponent
implements Identifiable {
    private Identifier identifier;
    static final Logger LOGGER = LoggerFactory.getLogger(CRSHelper.class);
    private static Map<Identifier, IdentifiableComponent> registry = new HashMap<Identifier, IdentifiableComponent>();

    public Identifier getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getAuthorityName() {
        return this.identifier.getAuthorityName();
    }

    @Override
    public String getAuthorityKey() {
        return this.identifier.getAuthorityKey();
    }

    @Override
    public String getCode() {
        return this.identifier.getCode();
    }

    @Override
    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getShortName() {
        return this.identifier.getShortName();
    }

    @Override
    public void setShortName(String uiName) {
        this.identifier.setShortName(uiName);
    }

    @Override
    public String getRemarks() {
        return this.identifier.getRemarks();
    }

    @Override
    public void setRemarks(String remarks) {
        this.identifier.setRemarks(remarks);
    }

    @Override
    public void addRemark(String new_remark) {
        this.identifier.addRemark(new_remark);
    }

    @Override
    public List<Identifiable> getAliases() {
        return this.identifier.getAliases();
    }

    @Override
    public boolean addAlias(Identifiable alias) {
        return this.identifier.addAlias(alias);
    }

    public IdentifiableComponent(Identifier identifier) {
        this.identifier = identifier;
        this.registerComponent();
    }

    private void registerComponent() {
        if (!registry.containsKey(this.getIdentifier())) {
            registry.put(this.getIdentifier(), this);
        } else {
            LOGGER.warn("A component has already been registered for key " + this.getAuthorityName() + ":" + this.getAuthorityKey() + ".");
        }
    }

    public static IdentifiableComponent getComponent(Identifier id) {
        return registry.get(id);
    }

    public boolean equals(Object object) {
        if (object instanceof Identifiable) {
            Identifiable other = (Identifiable)object;
            return this.getAuthorityName() != null && other.getAuthorityName() != null && this.getAuthorityName().toUpperCase().equals(other.getAuthorityName().toUpperCase()) && this.getAuthorityKey() != null && other.getAuthorityKey() != null && this.getAuthorityKey().equals(other.getAuthorityKey()) || this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.identifier != null ? this.identifier.hashCode() : 0);
        return hash;
    }

    public String toString() {
        if (this.identifier != null) {
            return "[" + this.identifier.getAuthorityName() + ":" + this.identifier.getAuthorityKey() + "] " + this.identifier.getName();
        }
        return null;
    }
}

