/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.IntIntIntProcedure;
import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix2DProcedure;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix3D
extends AbstractMatrix3D {
    protected ObjectMatrix3D() {
    }

    public Object aggregate(ObjectObjectFunction aggr, ObjectFunction f) {
        if (this.size() == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int d = 1;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns - d;
                while (--column >= 0) {
                    a = aggr.apply(a, f.apply(this.getQuick(slice, row, column)));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(ObjectMatrix3D other, ObjectObjectFunction aggr, ObjectObjectFunction f) {
        this.checkShape(other);
        if (this.size() == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1), other.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int d = 1;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns - d;
                while (--column >= 0) {
                    a = aggr.apply(a, f.apply(this.getQuick(slice, row, column), other.getQuick(slice, row, column)));
                }
                d = 0;
            }
        }
        return a;
    }

    public ObjectMatrix3D assign(Object[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int slice = this.slices;
        while (--slice >= 0) {
            Object[][] currentSlice = values[slice];
            if (currentSlice.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
            }
            int row = this.rows;
            while (--row >= 0) {
                Object[] currentRow = currentSlice[row];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, currentRow[column]);
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectFunction function) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, function.apply(this.getQuick(slice, row, column)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, other.getQuick(slice, row, column));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D y, ObjectObjectFunction function) {
        this.checkShape(y);
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, function.apply(this.getQuick(slice, row, column), y.getQuick(slice, row, column)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(Object value) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    this.setQuick(slice, row, column, value);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(slice, row, column) == null) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public ObjectMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix3D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix3D other = (ObjectMatrix3D)otherObj;
        if (this.rows != other.rows()) {
            return false;
        }
        if (this.columns != other.columns()) {
            return false;
        }
        if (!testForEquality) {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    int column = this.columns;
                    while (--column >= 0) {
                        if (this.getQuick(slice, row, column) == other.getQuick(slice, row, column)) continue;
                        return false;
                    }
                }
            }
        } else {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    int column = this.columns;
                    while (--column >= 0) {
                        if (this.getQuick(slice, row, column) != null ? this.getQuick(slice, row, column).equals(other.getQuick(slice, row, column)) : other.getQuick(slice, row, column) == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Object get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    protected ObjectMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = this.slices;
        int r = this.rows;
        int c = this.columns;
        for (int slice = 0; slice < s; ++slice) {
            for (int row = 0; row < r; ++row) {
                for (int column = 0; column < c; ++column) {
                    Object value = this.getQuick(slice, row, column);
                    if (value == null) continue;
                    sliceList.add(slice);
                    rowList.add(row);
                    columnList.add(column);
                    valueList.add(value);
                }
            }
        }
    }

    public abstract Object getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(ObjectMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        return false;
    }

    public ObjectMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract ObjectMatrix3D like(int var1, int var2, int var3);

    protected abstract ObjectMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int slice, int row, int column, Object value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, Object var4);

    public Object[][][] toArray() {
        Object[][][] values = new Object[this.slices][this.rows][this.columns];
        int slice = this.slices;
        while (--slice >= 0) {
            Object[][] currentSlice = values[slice];
            int row = this.rows;
            while (--row >= 0) {
                Object[] currentRow = currentSlice[row];
                int column = this.columns;
                while (--column >= 0) {
                    currentRow[column] = this.getQuick(slice, row, column);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix3D view() {
        return (ObjectMatrix3D)this.clone();
    }

    public ObjectMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewColumnFlip() {
        return (ObjectMatrix3D)this.view().vColumnFlip();
    }

    public ObjectMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (ObjectMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public ObjectMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (ObjectMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public ObjectMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewRowFlip() {
        return (ObjectMatrix3D)this.view().vRowFlip();
    }

    public ObjectMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = sliceIndexes.length;
        while (--i2 >= 0) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
        }
        i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public ObjectMatrix3D viewSelection(ObjectMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!condition.apply(this.viewSlice(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    protected abstract ObjectMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public ObjectMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewSliceFlip() {
        return (ObjectMatrix3D)this.view().vSliceFlip();
    }

    public ObjectMatrix3D viewSorted(int row, int column) {
        return Sorting.mergeSort.sort(this, row, column);
    }

    public ObjectMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (ObjectMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    private boolean xforEach(ObjectProcedure procedure) {
        int slice = this.slices;
        while (--slice >= 0) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (procedure.apply(this.getQuick(slice, row, column))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean xforEachCoordinate(IntIntIntProcedure procedure) {
        int column = this.columns;
        while (--column >= 0) {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    if (procedure.apply(slice, row, column)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

