import ibis.expr.operations as ops

IBIS_SUBSTRAIT_OP_MAPPING = {
    "Abs": "abs",
    "Acos": "acos",
    "Add": "add",
    "And": "and",
    "Any": "any",
    "Asin": "asin",
    "Atan": "atan",
    "Atan2": "atan2",
    "Between": "between",
    "Capitalize": "capitalize",
    "Ceil": "ceil",
    "Coalesce": "coalesce",
    "Cos": "cos",
    "Count": "count",
    "CountDistinct": "countdistinct",
    "Divide": "divide",
    "EndsWith": "ends_with",
    "Equals": "equal",
    "Exp": "exp",
    "ExtractYear": "extract",
    "ExtractMonth": "extract",
    "ExtractDay": "extract",
    "Floor": "floor",
    "Greater": "gt",
    "GreaterEqual": "gte",
    "IsInf": "is_infinite",
    "IsNan": "is_nan",
    "IsNull": "is_null",
    "Less": "lt",
    "LessEqual": "lte",
    "Ln": "ln",
    "Log": "logb",
    "Log2": "log2",
    "Log10": "log10",
    "Lowercase": "lower",
    "LPad": "lpad",
    "LStrip": "ltrim",
    "Max": "max",
    "Mean": "avg",
    "Min": "min",
    "Modulus": "modulus",
    "Multiply": "multiply",
    "Negate": "negate",
    "Not": "not",
    "NotEquals": "not_equal",
    "NotNull": "is_not_null",
    "NullIf": "nullif",
    "Or": "or",
    "Power": "power",
    "RegexExtract": "regexp_match_substring",
    "RegexReplace": "regexp_replace",
    "Repeat": "repeat",
    "Reverse": "reverse",
    "RPad": "rpad",
    "RStrip": "rtrim",
    "Sign": "sign",
    "Sin": "sin",
    "Sqrt": "sqrt",
    "StartsWith": "starts_with",
    "StringFind": "strpos",
    "StringConcat": "concat",
    "StringContains": "contains",
    "StringLength": "char_length",
    "StringReplace": "replace",
    "StringSplit": "string_split",
    "StringSQLLike": "like",
    "Strip": "trim",
    "StrRight": "right",
    "Substring": "substring",
    "Subtract": "subtract",
    "Sum": "sum",
    "Tan": "tan",
    "Uppercase": "upper",
    "Xor": "xor",
}

SUBSTRAIT_IBIS_OP_MAPPING = {
    v: getattr(ops, k) for k, v in IBIS_SUBSTRAIT_OP_MAPPING.items() if hasattr(ops, k)
}
# override when reversing many-to-one mappings
SUBSTRAIT_IBIS_OP_MAPPING["extract"] = lambda span, table: getattr(
    ops, f"Extract{span.capitalize()}"
)(table)
