__all__ = ['DirectSessionPanel']

import tkinter
from collections.abc import Callable, MutableMapping

import Pmw  # type: ignore[import]
from direct.directtools.DirectLights import DirectLight
from direct.tkwidgets.AppShell import AppShell
from direct.tkwidgets.Dial import AngleDial
from direct.tkwidgets.Floater import Floater
from direct.tkwidgets.MemoryExplorer import MemoryExplorer
from direct.tkwidgets.SceneGraphExplorer import SceneGraphExplorer
from direct.tkwidgets.Slider import Slider
from direct.tkwidgets.VectorWidgets import ColorEntry
from panda3d._typing import Vec3Like, Vec4Like
from panda3d.core import NodePath

from .TaskManagerPanel import TaskManagerWidget

class DirectSessionPanel(AppShell):
    activeLight: DirectLight | None
    nodePathDict: dict[str, NodePath]
    nodePathNames: list[str]
    jbNodePathDict: dict[str, NodePath]
    jbNodePathNames: list[str]
    actionEvents: list[tuple[str, Callable[..., None]]]
    directEnabled: tkinter.BooleanVar
    directGridEnabled: tkinter.BooleanVar
    directWidgetOnTop: tkinter.BooleanVar
    nodePathMenu: Pmw.ComboBox
    nodePathMenuEntry: tkinter.Entry
    nodePathMenuBG: str
    undoButton: tkinter.Button
    redoButton: tkinter.Button
    SGE: SceneGraphExplorer
    backgroundColor: ColorEntry
    drMenu: Pmw.ComboBox
    nearPlane: Floater
    farPlane: Floater
    hFov: Slider
    vFov: Slider
    lockedFov: tkinter.BooleanVar
    lockedFovButton: tkinter.Checkbutton
    resetFovButton: tkinter.Button
    toggleBackfaceButton: tkinter.Button
    toggleLightsButton: tkinter.Button
    toggleTextureButton: tkinter.Button
    toggleWireframeButton: tkinter.Button
    lightsButton: tkinter.Menubutton
    lightNotebook: Pmw.NoteBook
    enableLights: tkinter.BooleanVar
    enableLightsButton: tkinter.Checkbutton
    lightMenu: Pmw.ComboBox
    lightActive: tkinter.BooleanVar
    lightActiveButton: tkinter.Checkbutton
    lightColor: ColorEntry
    dSpecularColor: ColorEntry
    pSpecularColor: ColorEntry
    pConstantAttenuation: Slider
    pLinearAttenuation: Slider
    pQuadraticAttenuation: Slider
    sSpecularColor: ColorEntry
    sConstantAttenuation: Slider
    sLinearAttenuation: Slider
    sQuadraticAttenuation: Slider
    sExponent: Slider
    enableGrid: tkinter.BooleanVar
    enableGridButton: tkinter.Checkbutton
    xyzSnap: tkinter.BooleanVar
    xyzSnapButton: tkinter.Checkbutton
    hprSnap: tkinter.BooleanVar
    hprSnapButton: tkinter.Checkbutton
    gridSpacing: Floater
    gridSize: Floater
    gridSnapAngle: AngleDial
    enableJoybox: tkinter.BooleanVar
    enableJoyboxButton: tkinter.Checkbutton
    jbModeMenu: Pmw.ComboBox
    jbNodePathMenu: Pmw.ComboBox
    jbNodePathMenuEntry: tkinter.Entry
    jbNodePathMenuBG: str
    jbXyzSF: Slider
    jbHprSF: Slider
    taskMgrPanel: TaskManagerWidget
    MemExp: MemoryExplorer
    def __init__(self, parent: tkinter.Toplevel | None = None, **kw) -> None: ...
    def createEnvPage(self, envPage: tkinter.Misc | None) -> None: ...
    def createLightsPage(self, lightsPage: tkinter.Misc | None) -> None: ...
    def createGridPage(self, gridPage: tkinter.Misc | None) -> None: ...
    def createDevicePage(self, devicePage: tkinter.Misc | None): ...
    def createTasksPage(self, tasksPage) -> None: ...
    def createMemPage(self, memPage) -> None: ...
    def toggleDirect(self) -> None: ...
    def toggleDirectGrid(self) -> None: ...
    def toggleWidgetOnTop(self) -> None: ...
    def selectedNodePathHook(self, nodePath: NodePath) -> None: ...
    def selectNodePathNamed(self, name: str) -> None: ...
    def addNodePath(self, nodePath: NodePath) -> None: ...
    def selectJBModeNamed(self, name: str) -> None: ...
    def selectJBNodePathNamed(self, name: str) -> None: ...
    def addJBNodePath(self, nodePath: NodePath) -> None: ...
    def addNodePathToDict(self, nodePath: NodePath, names: list[str], menu, dict: MutableMapping[str, NodePath]) -> None: ...
    def setBackgroundColor(self, r: float, g: float, b: float) -> None: ...
    def setBackgroundColorVec(self, color: Vec3Like) -> None: ...
    def selectDisplayRegionNamed(self, name: str) -> None: ...
    def setNear(self, near) -> None: ...
    def setFar(self, far) -> None: ...
    def setHFov(self, hFov) -> None: ...
    def setVFov(self, vFov) -> None: ...
    def resetFov(self) -> None: ...
    def selectLightNamed(self, name: str) -> None: ...
    def addAmbient(self): ...
    def addDirectional(self): ...
    def addPoint(self): ...
    def addSpot(self): ...
    def addLight(self, light) -> None: ...
    def toggleLights(self) -> None: ...
    def toggleActiveLight(self) -> None: ...
    def setLightColor(self, color: Vec4Like) -> None: ...
    def setSpecularColor(self, color: Vec4Like) -> None: ...
    def setConstantAttenuation(self, value) -> None: ...
    def setLinearAttenuation(self, value) -> None: ...
    def setQuadraticAttenuation(self, value) -> None: ...
    def setExponent(self, value) -> None: ...
    def toggleGrid(self) -> None: ...
    def toggleXyzSnap(self) -> None: ...
    def toggleHprSnap(self) -> None: ...
    def toggleJoybox(self) -> None: ...
    def updateInfo(self, page: str = 'Environment') -> None: ...
    def updateEnvironmentInfo(self) -> None: ...
    def updateDisplayRegionInfo(self) -> None: ...
    def updateLightInfo(self, page=None) -> None: ...
    def updateGridInfo(self) -> None: ...
    def pushUndo(self, fResetRedo: bool = ...) -> None: ...
    def undoHook(self, nodePathList=...) -> None: ...
    def pushUndoHook(self) -> None: ...
    def undoListEmptyHook(self) -> None: ...
    def pushRedo(self) -> None: ...
    def redoHook(self, nodePathList=...) -> None: ...
    def pushRedoHook(self) -> None: ...
    def redoListEmptyHook(self) -> None: ...
