from typing import ClassVar

from direct._typing import Unused
from direct.directnotify.Notifier import Notifier
from direct.showbase.ProfileSession import ProfileSession

class TaskTracker:
    notify: ClassVar[Notifier]
    MinSamples: ClassVar[int | None]
    SpikeThreshold: ClassVar[float | None]
    def __init__(self, namePrefix: str) -> None: ...
    def destroy(self) -> None: ...
    def flush(self) -> None: ...
    def getNamePrefix(self, namePrefix: Unused) -> str: ...
    def addProfileSession(self, session: ProfileSession) -> None: ...
    def getAvgDuration(self) -> float: ...
    def getNumDurationSamples(self) -> int: ...
    def getAvgSession(self) -> ProfileSession: ...
    def log(self) -> None: ...

class TaskProfiler:
    notify: ClassVar[Notifier]
    def __init__(self) -> None: ...
    def destroy(self) -> None: ...
    @staticmethod
    def GetDefaultSpikeThreshold() -> float: ...
    @staticmethod
    def SetSpikeThreshold(spikeThreshold: float) -> None: ...
    @staticmethod
    def GetSpikeThreshold() -> float: ...
    def logProfiles(self, name: str | None = None) -> None: ...
    def flush(self, name: str | None) -> None: ...
