from collections.abc import Callable, Iterable
from pstats import Stats
from typing import Any, ClassVar
from typing_extensions import Self

from direct.directnotify.Notifier import Notifier
from panda3d.core import TrueClock

class PercentStats(Stats):
    def setTotalTime(self, tt: float) -> None: ...
    def f8(self, x: float) -> str: ...
    @staticmethod
    def func_std_string(func_name: tuple[object, float, object]) -> str: ...

class ProfileSession:
    TrueClock: ClassVar[TrueClock]
    notify: ClassVar[Notifier]
    def __init__(self, name: str, func: Callable[[], Any] | None = None, logAfterProfile: bool = False) -> None: ...
    def getReference(self) -> Self: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def run(self) -> Any: ...
    def getDuration(self) -> float | None: ...
    def profileSucceeded(self) -> bool: ...
    def setName(self, name: str) -> None: ...
    def getName(self) -> str: ...
    def setFunc(self, func: Callable[[], Any]) -> None: ...
    def getFunc(self) -> Callable[[], Any] | None: ...
    def setAggregate(self, aggregate: bool) -> None: ...
    def getAggregate(self) -> bool: ...
    def setLogAfterProfile(self, logAfterProfile: bool) -> None: ...
    def getLogAfterProfile(self) -> bool: ...
    def setLines(self, lines: int) -> None: ...
    def getLines(self) -> int: ...
    def setSorts(self, sorts: Iterable[str]) -> None: ...
    def getSorts(self) -> Iterable[str]: ...
    def setShowCallInfo(self, showCallInfo: bool) -> None: ...
    def getShowCallInfo(self) -> bool: ...
    def setTotalTime(self, totalTime: float | None = None) -> None: ...
    def resetTotalTime(self) -> None: ...
    def getTotalTime(self) -> float: ...
    def aggregate(self, other: ProfileSession) -> None: ...
    def getResults(self, lines: int = ..., sorts: Iterable[str] = ..., callInfo: bool = ..., totalTime: float = ...) -> str: ...
