from _typeshed import StrOrBytesPath
from typing import ClassVar

from direct.directnotify.Notifier import Notifier
from panda3d.core import NodePath
from panda3d.physics import BaseForce

from .ForceGroup import ForceGroup
from .Particles import Particles

class ParticleEffect(NodePath):
    notify: ClassVar[Notifier]
    pid: ClassVar[int]
    fEnabled: bool
    particlesDict: dict[str, Particles]
    forceGroupDict: dict[str, ForceGroup]
    renderParent: NodePath | None
    def __init__(self, name: str | None = None, particles: Particles | None = None) -> None: ...
    def cleanup(self) -> None: ...
    def getName(self) -> str: ...  # type: ignore[override]
    def reset(self) -> None: ...
    def start(self, parent: NodePath | None = None, renderParent: NodePath | None = None) -> None: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def is_enabled(self) -> bool: ...
    def add_force_group(self, forceGroup: ForceGroup) -> None: ...
    def add_force(self, force: BaseForce) -> None: ...
    def remove_force_group(self, forceGroup: ForceGroup) -> None: ...
    def remove_force(self, force: BaseForce) -> None: ...
    def remove_all_forces(self) -> None: ...
    def add_particles(self, particles: Particles) -> None: ...
    def remove_particles(self, particles: Particles) -> None: ...
    def remove_all_particles(self) -> None: ...
    def get_particles_list(self) -> list[Particles]: ...
    def get_particles_named(self, name: str) -> Particles | None: ...
    def get_particles_dict(self) -> dict[str, Particles]: ...
    def get_force_group_list(self) -> list[ForceGroup]: ...
    def get_force_group_named(self, name: str) -> ForceGroup | None: ...
    def get_force_group_dict(self) -> dict[str, ForceGroup]: ...
    def save_config(self, filename: StrOrBytesPath) -> None: ...
    def load_config(self, filename: StrOrBytesPath) -> None: ...
    def accelerate(self, time: float, stepCount: int = 1, stepTime: float = 0.0) -> None: ...
    def clear_to_initial(self) -> None: ...
    def soft_stop(self) -> None: ...
    def soft_start(self, firstBirthDelay: float | None = None) -> None: ...
    isEnabled = is_enabled
    addForceGroup = add_force_group
    addForce = add_force
    removeForceGroup = remove_force_group
    removeForce = remove_force
    removeAllForces = remove_all_forces
    addParticles = add_particles
    removeParticles = remove_particles
    removeAllParticles = remove_all_particles
    getParticlesList = get_particles_list
    getParticlesNamed = get_particles_named
    getParticlesDict = get_particles_dict
    getForceGroupList = get_force_group_list
    getForceGroupNamed = get_force_group_named
    getForceGroupDict = get_force_group_dict
    saveConfig = save_config
    loadConfig = load_config
    clearToInitial = clear_to_initial
    softStop = soft_stop
    softStart = soft_start
