from abc import ABCMeta, abstractmethod
from typing import Any

import wx  # type: ignore[import]
import wx.siplib as sip  # type: ignore[import]
from direct._typing import Obj, Unused
from panda3d.core import NodePath

from .LevelEditor import LevelEditor

class SceneGraphUIDropTarget(wx.TextDropTarget, metaclass=sip.wrapper):
    editor: LevelEditor
    def __init__(self, editor: LevelEditor) -> None: ...
    def OnDropText(self, x, y, text: str) -> None: ...

class SceneGraphUIBase(wx.Panel, metaclass=ABCMeta):
    editor: LevelEditor
    tree: wx.TreeCtrl
    root: wx.TreeItemId
    shouldShowPandaObjChildren: bool
    currItem = ...
    currObj: Obj
    menu: wx.Menu
    def __init__(self, parent: Any, editor: LevelEditor) -> None: ...
    def reset(self) -> None: ...
    def traversePandaObjects(self, parent, objNodePath: NodePath) -> None: ...
    def addPandaObjectChildren(self, parent) -> None: ...
    def removePandaObjectChildren(self, parent) -> None: ...
    def add(self, item, parentNP: NodePath | None = None) -> None: ...
    def traverse(self, parent, itemId: str): ...
    def reParentTree(self, parent, newParent) -> None: ...
    def reParentData(self, parent, child) -> None: ...
    def reParent(self, oldParent, newParent, child) -> None: ...
    def isChildOrGrandChild(self, parent, child): ...
    def changeHierarchy(self, data: str, x, y) -> None: ...
    def parent(self, oldParentId: str, newParentId: str, childName: str) -> None: ...
    def showPandaObjectChildren(self) -> None: ...
    def delete(self, itemId: str) -> None: ...
    def select(self, itemId: str) -> None: ...
    def changeLabel(self, itemId: str, newName: str) -> None: ...
    def deSelect(self, itemId: str) -> None: ...
    def onSelected(self, event) -> None: ...
    def onBeginDrag(self, event) -> None: ...
    def onShowPopup(self, event) -> None: ...
    def populateMenu(self) -> None: ...
    @abstractmethod
    def populateExtraMenu(self) -> None: ...
    def onCollapseAllChildren(self, evt: Unused = None) -> None: ...
    def onExpandAllChildren(self, evt: Unused = None) -> None: ...
    def onDelete(self, evt: Unused = None) -> None: ...
    def onRename(self, evt: Unused = None) -> None: ...
