from collections.abc import Callable, Sequence
from typing import Protocol, TypeVar

from direct._typing import Incomplete, Obj, Unused
from direct.interval import MetaInterval
from direct.interval.ActorInterval import ActorInterval
from direct.interval.LerpInterval import LerpFunc
from direct.showutil.Rope import Rope
from panda3d.core import LVecBase3f, NodePath

from .LevelEditor import LevelEditor

_T = TypeVar('_T', contravariant=True)

# Mypy says `_T` should be covariant, but Pyright says contravariant.
# Pyright appears to be correct.
class _SupportsAppend(Protocol[_T]):  # type: ignore[misc]
    def append(__item: _T) -> object: ...

class AnimMgrBase:
    editor: LevelEditor
    graphEditorCounter: int
    keyFramesInfo: dict
    curveAnimation: dict
    lerpFuncs: dict[str, Callable[..., None]]
    curveLerpFuncs: dict[str, tuple[Callable[..., None], Callable[..., None]]]
    keyFrames: list
    points: list[LVecBase3f]
    hprs: list[LVecBase3f]
    curveSequence: MetaInterval.Sequence
    parallel: MetaInterval.Parallel
    def __init__(self, editor: LevelEditor) -> None: ...
    def reset(self) -> None: ...
    def generateKeyFrames(self) -> None: ...
    def generateSlope(self, list: Sequence) -> None: ...
    def removeAnimInfo(self, uid) -> None: ...
    def singleCurveAnimation(self, nodePath: NodePath, curve: Obj[Rope, Incomplete], time: int) -> MetaInterval.Sequence: ...
    def createParallel(self, startFrame: int, endFrame: int) -> MetaInterval.Parallel: ...
    def createCurveAnimation(self, parallel: _SupportsAppend[MetaInterval.Sequence]) -> None: ...
    def createActorAnimation(self, parallel: _SupportsAppend[ActorInterval], startFrame: int, endFrame: int) -> None: ...
    def createKeyFrameAnimation(
        self, parallel: _SupportsAppend[LerpFunc | MetaInterval.Sequence], startFrame: int, endFrame: int
    ) -> None: ...
    def createCurveKeyFrameAnimation(
        self, parallel: _SupportsAppend[MetaInterval.Sequence], startFrame: int, endFrame: int
    ) -> None: ...
    def getPos(self, x: float, list: Sequence, i: int) -> float: ...
    def calculateT(self, a: float, b: float, c: float, d: float, x: Unused) -> float: ...
    def lerpFuncX(self, pos: LVecBase3f, np: NodePath) -> None: ...
    def lerpFuncY(self, pos: LVecBase3f, np: NodePath) -> None: ...
    def lerpFuncZ(self, pos: LVecBase3f, np: NodePath) -> None: ...
    def lerpCurveFuncX(self, t: float, extraArgs) -> None: ...
    def lerpCurveFuncY(self, t: float, extraArgs) -> None: ...
    def lerpCurveFuncZ(self, t: float, extraArgs) -> None: ...
    def lerpFuncH(self, angle: float, np: NodePath) -> None: ...
    def lerpFuncP(self, angle: float, np: NodePath) -> None: ...
    def lerpFuncR(self, angle: float, np: NodePath) -> None: ...
    def lerpFuncSX(self, scale: float, np: NodePath) -> None: ...
    def lerpFuncSY(self, scale: float, np: NodePath) -> None: ...
    def lerpFuncSZ(self, scale: float, np: NodePath) -> None: ...
    def lerpFuncCR(self, R: float, np: NodePath) -> None: ...
    def lerpFuncCG(self, G: float, np: NodePath) -> None: ...
    def lerpFuncCB(self, B: float, np: NodePath) -> None: ...
    def lerpFuncCA(self, A: float, np: NodePath) -> None: ...
    def colorUpdate(self, r: float, g: float, b: float, a: float, np: NodePath) -> None: ...
