from typing import Any

import wx  # type: ignore[import]
import wx.siplib as sip  # type: ignore[import]
from direct._typing import Unused
from wx.lib.embeddedimage import PyEmbeddedImage  # type: ignore[import]

from .LevelEditor import LevelEditor

FirstFrame: PyEmbeddedImage
PreFrame: PyEmbeddedImage
PreKeyFrame: PyEmbeddedImage
PrePlay: PyEmbeddedImage
Play: PyEmbeddedImage
NextKeyFrame: PyEmbeddedImage
NextFrame: PyEmbeddedImage
LastFrame: PyEmbeddedImage
Key: PyEmbeddedImage
Stop: PyEmbeddedImage
DeleteKey: PyEmbeddedImage

class TimeSlider(wx.Window, metaclass=sip.wrapper):
    points: list[tuple[tuple[float, int], tuple[float, int]]]
    numbers: list[int]
    curFrame: int
    sliderStartFrame: int
    sliderEndFrame: int
    frameNum: int
    buffer: wx.Bitmap
    unitWidth: float
    def __init__(self, parent: Any, slidersize, sliderStartFrame: int, sliderEndFrame: int, curFrame: int) -> None: ...
    def InitBuffer(self) -> None: ...
    def SetTimeSliderData(self, sliderStartFrame: int = 1, sliderEndFrame: int = 24, curFrame: int = 0) -> None: ...
    def OnPaint(self, evt) -> None: ...
    def DrawTimeSlider(self, dc) -> None: ...
    def DrawNumber(self, dc) -> None: ...
    def DrawFrame(self, dc) -> None: ...
    def DrawKeys(self, dc) -> None: ...
    def OnSize(self, evt) -> None: ...
    def OnLeftDown(self, evt) -> None: ...
    def OnLeftUp(self, evt) -> None: ...
    def OnMotion(self, evt) -> None: ...

class TimeRange(wx.Window, metaclass=sip.wrapper):
    startFrame: int
    endFrame: int
    sliderStartFrame: int
    sliderEndFrame: int
    frameNum: int
    w: int
    h: int
    buffer: wx.Bitmap
    unitWidth: float
    rangePosX: float
    rangePosY: float
    rangeWidth: float
    rangeHeight: float
    curRect: wx.Rect
    def __init__(
        self, parent: Any, rangesize, startFrame: int, endFrame: int, sliderStartFrame: int, sliderEndFrame: int
    ) -> None: ...
    def InitBuffer(self) -> None: ...
    def SetTimeRangeData(
        self, startFrame: int = 1, endFrame: int = 24, sliderStartFrame: int = 1, sliderEndFrame: int = 24
    ) -> None: ...
    def OnPaint(self, evt: Unused) -> None: ...
    def DrawTimeRange(self, dc) -> None: ...
    def OnSize(self, evt) -> None: ...
    def OnLeftDown(self, evt) -> None: ...
    def OnLeftUp(self, evt) -> None: ...
    def OnMotion(self, evt) -> None: ...
    def MainPanelUpdate(self) -> None: ...

class AnimControlUI(wx.Dialog, metaclass=sip.wrapper):
    editor: LevelEditor
    parallel: list
    keys: list[int]
    prePlay: bool
    play: bool
    stop: bool
    curFrame: int
    startFrame: int
    sliderStartFrame: int
    endFrame: int
    sliderEndFrame: int
    mainPanel1: wx.Panel
    timeSlider: TimeSlider
    curFrameSpin: wx.SpinCtrl
    bmpPrePlay: wx.Bitmap
    bmpPlay: wx.Bitmap
    bmpStop: wx.Bitmap
    buttonFirstFrame: wx.BitmapButton
    buttonPreFrame: wx.BitmapButton
    buttonPreKeyFrame: wx.BitmapButton
    buttonPrePlay: wx.BitmapButton
    buttonPlay: wx.BitmapButton
    buttonNextKeyFrame: wx.BitmapButton
    buttonNextFrame: wx.BitmapButton
    buttonLastFrame: wx.BitmapButton
    mainPanel2: wx.Panel
    timeStartSpin: wx.SpinCtrl
    timeSliderStartSpin: wx.SpinCtrl
    timeRange: TimeRange
    timeSliderEndSpin: wx.SpinCtrl
    timeEndSpin: wx.SpinCtrl
    buttonDeleteKey: wx.BitmapButton
    timeUnit: float
    timer: wx.Timer
    dialogSizer: wx.BoxSizer
    def __init__(self, parent: Any, editor: LevelEditor) -> None: ...
    def SetProperties(self) -> None: ...
    def DoLayout(self) -> None: ...
    def OnCurrentTime(self, evt) -> None: ...
    def OnControl(self) -> None: ...
    def OnFirstFrame(self, evt: Unused) -> None: ...
    def OnPreFrame(self, evt) -> None: ...
    def sortKey(self) -> None: ...
    def OnPreKeyFrame(self, evt: Unused) -> None: ...
    def OnTimer(self, evt: Unused) -> None: ...
    def OnPrePlay(self, evt) -> None: ...
    def OnPlay(self, evt) -> None: ...
    def OnNextKeyFrame(self, evt: Unused) -> None: ...
    def OnNextFrame(self, evt) -> None: ...
    def OnLastFrame(self, evt: Unused) -> None: ...
    def OnTime(self) -> None: ...
    def OnTimeStartSpin(self, evt) -> None: ...
    def OnTimeSliderStartSpin(self, evt) -> None: ...
    def OnTimeSliderEndSpin(self, evt) -> None: ...
    def OnTimeEndSpin(self, evt) -> None: ...
    def OnDeleteKey(self, evt: Unused) -> None: ...
    def OnPropKey(self) -> None: ...
    def OnAnimation(self, curFrame: int) -> None: ...
    def OnExit(self, evt: Unused) -> None: ...
