__all__ = ['FourState']

from collections.abc import Sequence
from typing import ClassVar, Protocol
from typing_extensions import Literal, TypeAlias

from direct.directnotify.Notifier import Notifier

from .ClassicFSM import ClassicFSM
from .State import State

_StateIndex: TypeAlias = Literal[0, 1, 2, 3, 4]

class _Track(Protocol):
    def pause(self) -> object: ...
    def start(self, __time: float) -> object: ...

class FourState:
    notify: ClassVar[Notifier]
    stateIndex: _StateIndex
    track: _Track | None
    stateTime: float
    names: Sequence[str]
    durations: Sequence[float | None]
    duration: float | None
    states: dict[_StateIndex, State]
    fsm: ClassicFSM
    def __init__(self, names: Sequence[str], durations: Sequence[float | None] = ...) -> None: ...
    def setTrack(self, track: _Track | None) -> None: ...
    def enterStateN(self, stateIndex: _StateIndex) -> None: ...
    def isOn(self) -> bool: ...
    def changedOnState(self, isOn: bool) -> None: ...
    def enterState0(self) -> None: ...
    def exitState0(self) -> None: ...
    def enterState1(self) -> None: ...
    def exitState1(self) -> None: ...
    def enterState2(self) -> None: ...
    def exitState2(self) -> None: ...
    def enterState3(self) -> None: ...
    def exitState3(self) -> None: ...
    def enterState4(self) -> None: ...
    def exitState4(self) -> None: ...
