from typing import SupportsFloat
from typing_extensions import Literal

from direct._typing import Unused
from panda3d.core import NodePath

from .ClientRepository import ClientRepository
from .DistributedNode import DistributedNode
from .DistributedSmoothNodeBase import DistributedSmoothNodeBase

MaxFuture: float
MinSuggestResync: float
EnableSmoothing: bool
EnablePrediction: bool
Lag: float
PredictionLag: float
GlobalSmoothing: bool
GlobalPrediction: bool

def globalActivateSmoothing(smoothing: bool, prediction: bool) -> None: ...
def activateSmoothing(smoothing: bool, prediction: bool) -> None: ...

class DistributedSmoothNode(DistributedNode, DistributedSmoothNodeBase):
    DistributedSmoothNode_initialized: Literal[1]
    smoothStarted: bool
    localControl: bool
    stopped: bool
    def __init__(self, cr: ClientRepository) -> None: ...
    def smoothPosition(self) -> None: ...
    def doSmoothTask(self, task: Unused) -> Literal[1]: ...
    def wantsSmoothing(self) -> bool: ...
    def startSmooth(self) -> None: ...
    def stopSmooth(self) -> None: ...
    def setSmoothWrtReparents(self, flag: bool) -> None: ...
    def getSmoothWrtReparents(self) -> bool: ...
    def forceToTruePosition(self) -> None: ...
    def reloadPosition(self) -> None: ...
    def setSmStop(self, timestamp: int | None = None) -> None: ...
    def setSmH(self, h: float, timestamp: int | None = None) -> None: ...
    def setSmZ(self, z: float, timestamp: int | None = None) -> None: ...
    def setSmXY(self, x: float, y: float, timestamp: int | None = None) -> None: ...
    def setSmXZ(self, x: float, z: float, timestamp: int | None = None) -> None: ...
    def setSmPos(self, x: float, y: float, z: float, timestamp: int | None = None) -> None: ...
    def setSmHpr(self, h: float, p: float, r: float, timestamp: int | None = None) -> None: ...
    def setSmXYH(self, x: float, y: float, h: float, timestamp: int | None) -> None: ...
    def setSmXYZH(self, x: float, y: float, z: float, h: float, timestamp: int | None = None) -> None: ...
    def setSmPosHpr(self, x: float, y: float, z: float, h: float, p: float, r: float, timestamp: int | None = None) -> None: ...
    def setSmPosHprL(
        self, l: int, x: float, y: float, z: float, h: float, p: float, r: float, timestamp: int | None = None
    ) -> None: ...
    def setComponentX(self, x: float) -> None: ...
    def setComponentY(self, y: float) -> None: ...
    def setComponentZ(self, z: float) -> None: ...
    def setComponentH(self, h: float) -> None: ...
    def setComponentP(self, p: float) -> None: ...
    def setComponentR(self, r: float) -> None: ...
    def setComponentL(self, l: int) -> None: ...
    def setComponentT(self, timestamp: Unused) -> None: ...
    def setComponentTLive(self, timestamp: int | None) -> None: ...
    def getComponentL(self) -> int: ...
    def getComponentX(self) -> float: ...
    def getComponentY(self) -> float: ...
    def getComponentZ(self) -> float: ...
    def getComponentH(self) -> float: ...
    def getComponentP(self) -> float: ...
    def getComponentR(self) -> float: ...
    def getComponentT(self) -> Literal[0]: ...
    def clearSmoothing(self, bogus: Unused = None) -> None: ...
    def wrtReparentTo(self, parent: NodePath) -> None: ...  # type: ignore[override]
    def d_suggestResync(self, avId: object, timestampA: int, timestampB: int, serverTime: float, uncertainty: float) -> None: ...
    def suggestResync(
        self,
        avId: object,
        timestampA: int,
        timestampB: int,
        serverTimeSec: SupportsFloat,
        serverTimeUSec: SupportsFloat,
        uncertainty: float,
    ) -> None: ...
    def d_returnResync(self, avId: object, timestampB: int, serverTime: float, uncertainty: float) -> None: ...
    def returnResync(
        self, avId: object, timestampB: int, serverTimeSec: SupportsFloat, serverTimeUSec: SupportsFloat, uncertainty: float
    ) -> None: ...
    def peerToPeerResync(self, avId: object, timestamp: int, serverTime: float, uncertainty: float) -> int: ...
    def activateSmoothing(self, smoothing: bool, prediction: bool) -> None: ...
