from typing import overload
from typing_extensions import Literal

from direct._typing import AnyReal, Unused
from panda3d._typing import Vec2Like

class CartesianGridBase:
    def isValidZone(self, zoneId: int) -> bool: ...
    @overload
    def getZoneFromXYZ(self, pos: Vec2Like, wantRowAndCol: Literal[False] = False) -> int: ...
    @overload
    def getZoneFromXYZ(self, pos: Vec2Like, wantRowAndCol: Literal[True]) -> tuple[int, float, float]: ...
    def getGridSizeFromSphereRadius(self, sphereRadius: AnyReal, cellWidth: AnyReal, gridRadius: AnyReal) -> AnyReal: ...
    def getGridSizeFromSphere(self, sphereRadius: float, spherePos: Vec2Like, cellWidth: float, gridRadius: Unused) -> float: ...
    def getZoneCellOrigin(self, zoneId: int) -> tuple[float, float, Literal[0]]: ...
    def getZoneCellOriginCenter(self, zoneId: int) -> tuple[float, float, Literal[0]]: ...
    def getConcentricZones(self, zoneId: int, radius: float) -> list[int]: ...
