from typing import Any, ClassVar, NoReturn, SupportsInt, SupportsRound
from typing_extensions import Literal

from panda3d.core import ConfigVariableBool, StreamWriter

from .Logger import Logger

class Notifier:
    serverDelta: ClassVar[int]
    streamWriter: ClassVar[StreamWriter | None]
    showTime: ClassVar[ConfigVariableBool]
    def __init__(self, name: str, logger: Logger | None = None) -> None: ...
    def setServerDelta(self, delta: SupportsRound[SupportsInt], timezone: int) -> None: ...
    def getTime(self) -> str: ...
    def getOnlyTime(self) -> str: ...
    def setSeverity(self, severity: int) -> None: ...
    def getSeverity(self) -> Literal[2, 3, 4, 5]: ...
    def error(self, errorString: object, exception: type[Exception] = ...) -> NoReturn: ...
    def warning(self, warningString: object) -> Literal[1]: ...
    def setWarning(self, bool: bool) -> None: ...
    def getWarning(self) -> bool: ...
    def debug(self, debugString: object) -> Literal[1]: ...
    def setDebug(self, bool: bool) -> None: ...
    def getDebug(self) -> bool: ...
    def info(self, infoString: object) -> Literal[1]: ...
    def getInfo(self) -> bool: ...
    def setInfo(self, bool: bool) -> None: ...
    def getLogging(self) -> bool: ...
    def setLogging(self, bool: bool) -> None: ...
    def debugStateCall(self, obj: Any = None, fsmMemberName: str = 'fsm', secondaryFsm: str = 'secondaryFSM') -> Literal[1]: ...
    def debugCall(self, debugString: object = '') -> Literal[1]: ...
