from abc import ABCMeta, abstractmethod
from typing import ClassVar
from typing_extensions import Final

from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject

class InputStateToken(metaclass=ABCMeta):
    Inval: Final = 'invalidatedToken'
    def __init__(self, inputState: InputState) -> None: ...
    @abstractmethod
    def release(self) -> None: ...
    def is_valid(self) -> bool: ...
    def invalidate(self) -> None: ...
    def __hash__(self) -> int: ...
    isValid = is_valid

class InputStateWatchToken(InputStateToken, DirectObject):
    def release(self) -> None: ...

class InputStateForceToken(InputStateToken):
    def release(self) -> None: ...

class InputStateTokenGroup:
    def __init__(self) -> None: ...
    def add_token(self, token: InputStateToken) -> None: ...
    def release(self) -> None: ...
    addToken = add_token

class InputState(DirectObject):
    notify: ClassVar[Notifier]
    WASD: Final = 'WASD'
    QE: Final = 'QE'
    ArrowKeys: Final = 'ArrowKeys'
    Keyboard: Final = 'Keyboard'
    Mouse: Final = 'Mouse'
    def __init__(self) -> None: ...
    def delete(self) -> None: ...
    def is_set(self, name: str, inputSource: str | None = None) -> bool: ...
    def get_event_name(self, name: object) -> str: ...
    def set(self, name: str, isActive: bool, inputSource: str | None = None) -> None: ...
    def release_inputs(self, name: str) -> None: ...
    def watch(
        self, name: str, eventOn: str, eventOff: str, startState: bool = False, inputSource: str | None = None
    ) -> InputStateWatchToken: ...
    def watch_with_modifiers(
        self, name: str, event: str, startState: bool = False, inputSource: str | None = None
    ) -> InputStateTokenGroup: ...
    def force(self, name: str, value: bool, inputSource: str) -> InputStateForceToken: ...
    def debug_print(self, message: str) -> None: ...
    isSet = is_set
    getEventName = get_event_name
    releaseInputs = release_inputs
    debugPrint = debug_print
    watchWithModifiers = watch_with_modifiers
