from typing import Any, ClassVar
from typing_extensions import Literal

from direct._typing import Unused
from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject
from panda3d.core import CollisionTraverser, ConfigVariableBool, ConfigVariableDouble, LVector3f, NodePath, PythonTask

class DevWalker(DirectObject):
    notify: ClassVar[Notifier]
    wantDebugIndicator: ClassVar[ConfigVariableBool]
    runMultiplier: ClassVar[ConfigVariableDouble]
    slideName: ClassVar[str]
    speed: float
    rotationSpeed: float
    slideSpeed: float
    vel: LVector3f
    task: PythonTask | None
    avatarControlForwardSpeed: float
    avatarControlReverseSpeed: float
    avatarControlRotateSpeed: float
    avatar: Any
    cTrav: CollisionTraverser
    avatarNodePath: NodePath
    liftSpeed: float
    def __init__(self) -> None: ...
    def setWalkSpeed(self, forward: float, jump: Unused, reverse: float, rotate: float) -> None: ...
    def getSpeeds(self) -> tuple[float, float, float]: ...
    def setAvatar(self, avatar: Any) -> None: ...
    def setWallBitMask(self, bitMask: Unused) -> None: ...
    def setFloorBitMask(self, bitMask: Unused) -> None: ...
    def initializeCollisions(
        self,
        collisionTraverser: CollisionTraverser,
        avatarNodePath: NodePath,
        wallCollideMask: Unused,
        floorCollideMask: Unused,
        avatarRadius: Unused = 1.4,
        floorOffset: Unused = 1.0,
        reach: Unused = 1.0,
    ) -> None: ...
    def setAirborneHeightFunc(self, getAirborneHeight: Unused) -> None: ...
    def deleteCollisions(self) -> None: ...
    def setTag(self, key: Unused, value: Unused) -> None: ...
    def setCollisionsActive(self, active: Unused = 1) -> None: ...
    def placeOnFloor(self) -> None: ...
    def oneTimeCollide(self) -> None: ...
    def addBlastForce(self, vector: Unused) -> None: ...
    def displayDebugInfo(self) -> None: ...
    def handleAvatarControls(self, task: Unused) -> Literal[1]: ...
    def enableAvatarControls(self) -> None: ...
    def disableAvatarControls(self) -> None: ...
    def flushEventHandlers(self) -> None: ...
