# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/judge.ipynb (unless otherwise specified).

__all__ = ['FormatJudge']

# Cell
import heapq
import numpy as np

from typing import Any, List

from nltk.lm import MLE
from nltk.util import ngrams
from nltk.lm.preprocessing import flatten
from nltk.lm.preprocessing import pad_both_ends

from .utils import PatternGenerator

# Cell
class FormatJudge:
    """Detects format errors on a tabular data set."""

    def __init__(self, generator: PatternGenerator, n: int = 1):
        self.generator = generator
        self.n = n

    def __call__(self, o: Any) -> list:
        return self.judge(o)

    def fit(self, values: List[Any]):
        patterns = [self.generator(v) for v in values]
        padded_patterns = [pad_both_ends(p, n=3) for p in patterns]
        trigrams = [ngrams(pp, n=3) for pp in padded_patterns]

        self.vocab = list(flatten(pad_both_ends(p, n=2) for p in patterns))
        self.model = MLE(3)
        self.model.fit(trigrams, self.vocab)

    def judge(self, o: Any) -> list:
        scores = []
        p = self.generator(o)
        p = list(pad_both_ends(p, n=3))
        for i,v in enumerate(p):
            if i < 2:
                continue
            scores.append(self.model.score(v, [p[i-2], p[i-1]]))
        return scores