# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/detector.ipynb (unless otherwise specified).

__all__ = ['FormatDetector']

# Cell
import pandas as pd
import numpy as np

from typing import Any
from tqdm import tqdm

from .judge import FormatJudge
from .utils import PatternGenerator

# Cell
class FormatDetector:
    def __init__(self):
        pass

    def fit(self, df: pd.DataFrame, generator: PatternGenerator, n: int = 1):
        self.judges = {}

        self.df = df
        with tqdm(total=len(self.df.columns)) as pbar:
            for col in self.df.columns:
                col_values = self.df[col].tolist()
                format_judge = FormatJudge(generator, n)
                format_judge.fit(col_values)
                self.judges[col] = format_judge
                pbar.update(1)

    def detect(self) -> dict:
        scores = []

        for index, row in self.df.iterrows():
            tuple_score = []
            for col in self.df.columns:
                judge = self.judges[col]
                tuple_score.append(np.mean(judge(row[col])))
            scores.append(1 - np.min(tuple_score))
        assessed_df = self.df.copy()
        assessed_df['p'] = scores
        return assessed_df