# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeSearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeSearchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'page_size': 'int',
            'page_number': 'int',
            'document_type': 'str',
            'language_code': 'str',
            'search_on_draft_documents': 'bool'
        }

        self.attribute_map = {
            'query': 'query',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'document_type': 'documentType',
            'language_code': 'languageCode',
            'search_on_draft_documents': 'searchOnDraftDocuments'
        }

        self._query = None
        self._page_size = None
        self._page_number = None
        self._document_type = None
        self._language_code = None
        self._search_on_draft_documents = None

    @property
    def query(self):
        """
        Gets the query of this KnowledgeSearchRequest.
        Input query to search content in the knowledge base

        :return: The query of this KnowledgeSearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this KnowledgeSearchRequest.
        Input query to search content in the knowledge base

        :param query: The query of this KnowledgeSearchRequest.
        :type: str
        """
        
        self._query = query

    @property
    def page_size(self):
        """
        Gets the page_size of this KnowledgeSearchRequest.
        Page size of the returned results

        :return: The page_size of this KnowledgeSearchRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """
        Sets the page_size of this KnowledgeSearchRequest.
        Page size of the returned results

        :param page_size: The page_size of this KnowledgeSearchRequest.
        :type: int
        """
        
        self._page_size = page_size

    @property
    def page_number(self):
        """
        Gets the page_number of this KnowledgeSearchRequest.
        Page number of the returned results

        :return: The page_number of this KnowledgeSearchRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """
        Sets the page_number of this KnowledgeSearchRequest.
        Page number of the returned results

        :param page_number: The page_number of this KnowledgeSearchRequest.
        :type: int
        """
        
        self._page_number = page_number

    @property
    def document_type(self):
        """
        Gets the document_type of this KnowledgeSearchRequest.
        Document type to be used while searching

        :return: The document_type of this KnowledgeSearchRequest.
        :rtype: str
        """
        return self._document_type

    @document_type.setter
    def document_type(self, document_type):
        """
        Sets the document_type of this KnowledgeSearchRequest.
        Document type to be used while searching

        :param document_type: The document_type of this KnowledgeSearchRequest.
        :type: str
        """
        allowed_values = ["Faq"]
        if document_type.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for document_type -> " + document_type
            self._document_type = "outdated_sdk_version"
        else:
            self._document_type = document_type

    @property
    def language_code(self):
        """
        Gets the language_code of this KnowledgeSearchRequest.
        query search for specific languageCode

        :return: The language_code of this KnowledgeSearchRequest.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this KnowledgeSearchRequest.
        query search for specific languageCode

        :param language_code: The language_code of this KnowledgeSearchRequest.
        :type: str
        """
        
        self._language_code = language_code

    @property
    def search_on_draft_documents(self):
        """
        Gets the search_on_draft_documents of this KnowledgeSearchRequest.
        If true the search query will be executed on draft documents, else it will be on active documents

        :return: The search_on_draft_documents of this KnowledgeSearchRequest.
        :rtype: bool
        """
        return self._search_on_draft_documents

    @search_on_draft_documents.setter
    def search_on_draft_documents(self, search_on_draft_documents):
        """
        Sets the search_on_draft_documents of this KnowledgeSearchRequest.
        If true the search query will be executed on draft documents, else it will be on active documents

        :param search_on_draft_documents: The search_on_draft_documents of this KnowledgeSearchRequest.
        :type: bool
        """
        
        self._search_on_draft_documents = search_on_draft_documents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

