# coding: utf-8

"""
OutboundApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class OutboundApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_outbound_attemptlimit(self, attempt_limits_id, **kwargs):
        """
        Delete attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_attemptlimit(attempt_limits_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `delete_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_callabletimeset(self, callable_time_set_id, **kwargs):
        """
        Delete callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_callabletimeset(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `delete_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_callanalysisresponseset(self, call_analysis_set_id, **kwargs):
        """
        Delete a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_callanalysisresponseset(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `delete_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaign(self, campaign_id, **kwargs):
        """
        Delete a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaign_progress(self, campaign_id, **kwargs):
        """
        Reset campaign progress and recycle the campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaign_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_campaign_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaignrule(self, campaign_rule_id, **kwargs):
        """
        Delete Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaignrule(campaign_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `delete_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist(self, contact_list_id, **kwargs):
        """
        Delete a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist_contact(self, contact_list_id, contact_id, **kwargs):
        """
        Delete a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist_contact(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist_contacts(self, contact_list_id, contact_ids, **kwargs):
        """
        Delete contacts from a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist_contacts(contact_list_id, contact_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[str] contact_ids: ContactIds to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist_contacts`")
        # verify the required parameter 'contact_ids' is set
        if ('contact_ids' not in params) or (params['contact_ids'] is None):
            raise ValueError("Missing the required parameter `contact_ids` when calling `delete_outbound_contactlist_contacts`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'contact_ids' in params:
            query_params['contactIds'] = params['contact_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlistfilter(self, contact_list_filter_id, **kwargs):
        """
        Delete Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlistfilter(contact_list_filter_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `delete_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlists(self, id, **kwargs):
        """
        Delete multiple contact lists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlists(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: contact list id(s) to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outbound_contactlists`")


        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist(self, dnc_list_id, **kwargs):
        """
        Delete dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_ruleset(self, rule_set_id, **kwargs):
        """
        Delete a Rule set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_ruleset(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `delete_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_campaign(self, campaign_id, **kwargs):
        """
        Delete a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_sequence(self, sequence_id, **kwargs):
        """
        Delete a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_sequence(self, sequence_id, **kwargs):
        """
        Delete a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_attemptlimit(self, attempt_limits_id, **kwargs):
        """
        Get attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_attemptlimit(attempt_limits_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `get_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_attemptlimits(self, **kwargs):
        """
        Query attempt limits list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_attemptlimits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: AttemptLimitsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_attemptlimits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/attemptlimits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimitsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callabletimeset(self, callable_time_set_id, **kwargs):
        """
        Get callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callabletimeset(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `get_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callabletimesets(self, **kwargs):
        """
        Query callable time set list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callabletimesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CallableTimeSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callanalysisresponseset(self, call_analysis_set_id, **kwargs):
        """
        Get a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callanalysisresponseset(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `get_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callanalysisresponsesets(self, **kwargs):
        """
        Query a list of dialer call analysis response sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callanalysisresponsesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ResponseSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign(self, campaign_id, **kwargs):
        """
        Get dialer campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_diagnostics(self, campaign_id, **kwargs):
        """
        Get campaign diagnostics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_diagnostics(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_diagnostics`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/diagnostics'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDiagnostics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_interactions(self, campaign_id, **kwargs):
        """
        Get dialer campaign interactions.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_interactions(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignInteractions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_interactions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_interactions`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/interactions'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignInteractions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_progress(self, campaign_id, **kwargs):
        """
        Get campaign progress
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignProgress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_stats(self, campaign_id, **kwargs):
        """
        Get statistics about a Dialer Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_stats(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_stats" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_stats`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/stats'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignStats',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaignrule(self, campaign_rule_id, **kwargs):
        """
        Get Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaignrule(campaign_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `get_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaignrules(self, **kwargs):
        """
        Query Campaign Rule list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaignrules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignRuleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaignrules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaignrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRuleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns(self, **kwargs):
        """
        Query a list of dialer campaigns.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str contact_list_id: Contact List ID
        :param str dnc_list_ids: DNC list ID
        :param str distribution_queue_id: Distribution queue ID
        :param str edge_group_id: Edge group ID
        :param str call_analysis_response_set_id: Call analysis response set ID
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'id', 'contact_list_id', 'dnc_list_ids', 'distribution_queue_id', 'edge_group_id', 'call_analysis_response_set_id', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']
        if 'dnc_list_ids' in params:
            query_params['dncListIds'] = params['dnc_list_ids']
        if 'distribution_queue_id' in params:
            query_params['distributionQueueId'] = params['distribution_queue_id']
        if 'edge_group_id' in params:
            query_params['edgeGroupId'] = params['edge_group_id']
        if 'call_analysis_response_set_id' in params:
            query_params['callAnalysisResponseSetId'] = params['call_analysis_response_set_id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_divisionview(self, campaign_id, **kwargs):
        """
        Get a basic Campaign information object
        This returns a simplified version of a Campaign, consisting of name and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_divisionview(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaigns_divisionview`")


        resource_path = '/api/v2/outbound/campaigns/divisionviews/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_divisionviews(self, **kwargs):
        """
        Query a list of basic Campaign information objects
        This returns a simplified version of a Campaign, consisting of name and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist(self, contact_list_id, **kwargs):
        """
        Get a dialer contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_contact(self, contact_list_id, contact_id, **kwargs):
        """
        Get a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_contact(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_export(self, contact_list_id, **kwargs):
        """
        Get the URI of a contact list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_importstatus(self, contact_list_id, **kwargs):
        """
        Get dialer contactList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_importstatus(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_importstatus`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_timezonemappingpreview(self, contact_list_id, **kwargs):
        """
        Preview the result of applying Automatic Time Zone Mapping to a contact list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_timezonemappingpreview(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: TimeZoneMappingPreview
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_timezonemappingpreview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_timezonemappingpreview`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/timezonemappingpreview'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeZoneMappingPreview',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlistfilter(self, contact_list_filter_id, **kwargs):
        """
        Get Contact list filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlistfilter(contact_list_filter_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `get_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlistfilters(self, **kwargs):
        """
        Query Contact list filters
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlistfilters(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str contact_list_id: Contact List ID
        :return: ContactListFilterEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order', 'contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlistfilters" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlistfilters'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilterEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists(self, **kwargs):
        """
        Query a list of contact lists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'id', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists_divisionview(self, contact_list_id, **kwargs):
        """
        Get a basic ContactList information object
        This returns a simplified version of a ContactList, consisting of the name, division, column names, phone columns, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists_divisionview(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contactlist ID (required)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :return: ContactListDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlists_divisionview`")


        resource_path = '/api/v2/outbound/contactlists/divisionviews/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists_divisionviews(self, **kwargs):
        """
        Query a list of simplified contact list objects.
        This return a simplified version of contact lists, consisting of the name, division, column names, phone columns, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist(self, dnc_list_id, **kwargs):
        """
        Get dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist_export(self, dnc_list_id, **kwargs):
        """
        Get the URI of a DNC list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist_importstatus(self, dnc_list_id, **kwargs):
        """
        Get dialer dncList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist_importstatus(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist_importstatus`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists(self, **kwargs):
        """
        Query dialer DNC lists
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str dnc_source_type: DncSourceType
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DncListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'dnc_source_type', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'dnc_source_type' in params:
            query_params['dncSourceType'] = params['dnc_source_type']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists_divisionview(self, dnc_list_id, **kwargs):
        """
        Get a basic DncList information object
        This returns a simplified version of a DncList, consisting of the name, division, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists_divisionview(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: Dnclist ID (required)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :return: DncListDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclists_divisionview`")


        resource_path = '/api/v2/outbound/dnclists/divisionviews/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists_divisionviews(self, **kwargs):
        """
        Query a list of simplified dnc list objects.
        This return a simplified version of dnc lists, consisting of the name, division, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DncListDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_event(self, event_id, **kwargs):
        """
        Get Dialer Event
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_event(event_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str event_id: Event Log ID (required)
        :return: EventLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_event" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'event_id' is set
        if ('event_id' not in params) or (params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_outbound_event`")


        resource_path = '/api/v2/outbound/events/{eventId}'.replace('{format}', 'json')
        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EventLog',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_events(self, **kwargs):
        """
        Query Event Logs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_events(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str category: Category
        :param str level: Level
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DialerEventEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'category', 'level', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_events" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'category' in params:
            query_params['category'] = params['category']
        if 'level' in params:
            query_params['level'] = params['level']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerEventEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_ruleset(self, rule_set_id, **kwargs):
        """
        Get a Rule Set by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_ruleset(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `get_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_rulesets(self, **kwargs):
        """
        Query a list of Rule Sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_rulesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: RuleSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_rulesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_campaign(self, campaign_id, **kwargs):
        """
        Get a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_campaigns(self, **kwargs):
        """
        Query for a list of dialer campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[CampaignSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_sequence(self, sequence_id, **kwargs):
        """
        Get a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_sequences(self, **kwargs):
        """
        Query for a list of dialer sequence schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[SequenceSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SequenceSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_sequence(self, sequence_id, **kwargs):
        """
        Get a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_sequences(self, **kwargs):
        """
        Query a list of dialer campaign sequences.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignSequenceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequenceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_settings(self, **kwargs):
        """
        Get the outbound settings for this organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OutboundSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_wrapupcodemappings(self, **kwargs):
        """
        Get the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_wrapupcodemappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_settings(self, body, **kwargs):
        """
        Update the outbound settings for this organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutboundSettings body: outboundSettings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_settings`")


        resource_path = '/api/v2/outbound/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_attemptlimits(self, body, **kwargs):
        """
        Create attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_attemptlimits(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AttemptLimits body: AttemptLimits (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_attemptlimits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_attemptlimits`")


        resource_path = '/api/v2/outbound/attemptlimits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_audits(self, body, **kwargs):
        """
        Retrieves audits for dialer.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_audits(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DialerAuditRequest body: AuditSearch (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param bool facets_only: Facets only
        :return: AuditSearchResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'page_size', 'page_number', 'sort_by', 'sort_order', 'facets_only']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_audits`")


        resource_path = '/api/v2/outbound/audits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'facets_only' in params:
            query_params['facetsOnly'] = params['facets_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AuditSearchResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_callabletimesets(self, body, **kwargs):
        """
        Create callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_callabletimesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CallableTimeSet body: DialerCallableTimeSet (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_callabletimesets`")


        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_callanalysisresponsesets(self, body, **kwargs):
        """
        Create a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_callanalysisresponsesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ResponseSet body: ResponseSet (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_callanalysisresponsesets`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaign_callback_schedule(self, campaign_id, body, **kwargs):
        """
        Schedule a Callback for a Dialer Campaign (Deprecated)
        This endpoint is deprecated and may have unexpected results. Please use \"/conversations/{conversationId}/participants/{participantId}/callbacks instead.\"

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaign_callback_schedule(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param ContactCallbackRequest body: ContactCallbackRequest (required)
        :return: ContactCallbackRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaign_callback_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_outbound_campaign_callback_schedule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaign_callback_schedule`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/callback/schedule'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactCallbackRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaignrules(self, body, **kwargs):
        """
        Create Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaignrules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CampaignRule body: CampaignRule (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaignrules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaignrules`")


        resource_path = '/api/v2/outbound/campaignrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaigns(self, body, **kwargs):
        """
        Create a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaigns(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Campaign body: Campaign (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaigns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaigns`")


        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaigns_progress(self, body, **kwargs):
        """
        Get progress for a list of campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaigns_progress(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Campaign IDs (required)
        :return: list[CampaignProgress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaigns_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaigns_progress`")


        resource_path = '/api/v2/outbound/campaigns/progress'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignProgress]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_clear(self, contact_list_id, **kwargs):
        """
        Deletes all contacts out of a list. All outstanding recalls or rule-scheduled callbacks for non-preview campaigns configured with the contactlist will be cancelled.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_clear(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_clear" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_clear`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/clear'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts(self, contact_list_id, body, **kwargs):
        """
        Add contacts to a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[WritableDialerContact] body: Contact (required)
        :param bool priority: Contact priority. True means the contact(s) will be dialed next; false means the contact will go to the end of the contact queue.
        :param bool clear_system_data: Clear system data. True means the system columns (attempts, callable status, etc) stored on the contact will be cleared if the contact already exists; false means they won't.
        :param bool do_not_queue: Do not queue. True means that updated contacts will not have their positions in the queue altered, so contacts that have already been dialed will not be redialed. For new contacts, this parameter has no effect; False means that updated contacts will be re-queued, according to the 'priority' parameter.
        :return: list[DialerContact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body', 'priority', 'clear_system_data', 'do_not_queue']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'priority' in params:
            query_params['priority'] = params['priority']
        if 'clear_system_data' in params:
            query_params['clearSystemData'] = params['clear_system_data']
        if 'do_not_queue' in params:
            query_params['doNotQueue'] = params['do_not_queue']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DialerContact]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts_bulk(self, contact_list_id, body, **kwargs):
        """
        Get contacts from a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts_bulk(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[str] body: ContactIds to get. (required)
        :return: list[DialerContact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts_bulk`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DialerContact]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_export(self, contact_list_id, **kwargs):
        """
        Initiate the export of a contact list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: DomainEntityRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityRef',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlistfilters(self, body, **kwargs):
        """
        Create Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlistfilters(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListFilter body: ContactListFilter (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlistfilters" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlistfilters`")


        resource_path = '/api/v2/outbound/contactlistfilters'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlistfilters_preview(self, body, **kwargs):
        """
        Get a preview of the output of a contact list filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlistfilters_preview(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListFilter body: ContactListFilter (required)
        :return: FilterPreviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlistfilters_preview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlistfilters_preview`")


        resource_path = '/api/v2/outbound/contactlistfilters/preview'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FilterPreviewResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlists(self, body, **kwargs):
        """
        Create a contact List.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlists(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactList body: ContactList (required)
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlists`")


        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_conversation_dnc(self, conversation_id, **kwargs):
        """
        Add phone numbers to a Dialer DNC list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_conversation_dnc(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_conversation_dnc" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_outbound_conversation_dnc`")


        resource_path = '/api/v2/outbound/conversations/{conversationId}/dnc'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclist_export(self, dnc_list_id, **kwargs):
        """
        Initiate the export of a dnc list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclist_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: DomainEntityRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_outbound_dnclist_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityRef',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclist_phonenumbers(self, dnc_list_id, body, **kwargs):
        """
        Add phone numbers to a Dialer DNC list.
        Only Internal DNC lists may be appended to

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclist_phonenumbers(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param list[str] body: DNC Phone Numbers (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclist_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_outbound_dnclist_phonenumbers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_dnclist_phonenumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/phonenumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclists(self, body, **kwargs):
        """
        Create dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclists(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DncListCreate body: DncList (required)
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_dnclists`")


        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_rulesets(self, body, **kwargs):
        """
        Create a Dialer Call Analysis Response Set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_rulesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RuleSet body: RuleSet (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_rulesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_rulesets`")


        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_sequences(self, body, **kwargs):
        """
        Create a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_sequences(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CampaignSequence body: Organization (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_sequences" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_sequences`")


        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_attemptlimit(self, attempt_limits_id, body, **kwargs):
        """
        Update attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_attemptlimit(attempt_limits_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :param AttemptLimits body: AttemptLimits (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `put_outbound_attemptlimit`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_callabletimeset(self, callable_time_set_id, body, **kwargs):
        """
        Update callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_callabletimeset(callable_time_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :param CallableTimeSet body: DialerCallableTimeSet (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `put_outbound_callabletimeset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_callanalysisresponseset(self, call_analysis_set_id, body, **kwargs):
        """
        Update a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_callanalysisresponseset(call_analysis_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :param ResponseSet body: ResponseSet (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `put_outbound_callanalysisresponseset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaign(self, campaign_id, body, **kwargs):
        """
        Update a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaign(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param Campaign body: Campaign (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_campaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaign_agent(self, campaign_id, user_id, body, **kwargs):
        """
        Send notification that an agent's state changed 
        New agent state.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaign_agent(campaign_id, user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param str user_id: Agent's user ID (required)
        :param Agent body: agent (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaign_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_campaign_agent`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_outbound_campaign_agent`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaign_agent`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/agents/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaignrule(self, campaign_rule_id, body, **kwargs):
        """
        Update Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaignrule(campaign_rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :param CampaignRule body: CampaignRule (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `put_outbound_campaignrule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlist(self, contact_list_id, body, **kwargs):
        """
        Update a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlist(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param ContactList body: ContactList (required)
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_outbound_contactlist`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlist_contact(self, contact_list_id, contact_id, body, **kwargs):
        """
        Update a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlist_contact(contact_list_id, contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :param DialerContact body: Contact (required)
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_outbound_contactlist_contact`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlistfilter(self, contact_list_filter_id, body, **kwargs):
        """
        Update Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlistfilter(contact_list_filter_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :param ContactListFilter body: ContactListFilter (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `put_outbound_contactlistfilter`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_dnclist(self, dnc_list_id, body, **kwargs):
        """
        Update dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_dnclist(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncList body: DncList (required)
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `put_outbound_dnclist`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_ruleset(self, rule_set_id, body, **kwargs):
        """
        Update a RuleSet.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_ruleset(rule_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :param RuleSet body: RuleSet (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `put_outbound_ruleset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_campaign(self, campaign_id, body, **kwargs):
        """
        Update a new campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_campaign(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param CampaignSchedule body: CampaignSchedule (required)
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_schedules_campaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_sequence(self, sequence_id, body, **kwargs):
        """
        Update a new sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_sequence(sequence_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :param SequenceSchedule body: SequenceSchedule (required)
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_outbound_schedules_sequence`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_sequence(self, sequence_id, body, **kwargs):
        """
        Update a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_sequence(sequence_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :param CampaignSequence body: Organization (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_outbound_sequence`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_wrapupcodemappings(self, body, **kwargs):
        """
        Update the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_wrapupcodemappings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WrapUpCodeMapping body: wrapUpCodeMapping (required)
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_wrapupcodemappings`")


        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
