import { custom_resources, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface OrganizationOUProviderProps {
    /**
     * The role the custom resource should use for taking actions on OUs if one is not provided one will be created automatically.
     *
     * @stability stable
     */
    readonly role?: iam.IRole;
}
/**
 * @stability stable
 */
export declare class OrganizationOUProvider extends Construct {
    /**
     * @stability stable
     */
    readonly provider: custom_resources.Provider;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: OrganizationOUProviderProps);
}
/**
 * @stability stable
 */
export interface OrganizationOUProps {
    /**
     * The name of the OU.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The parent OU id.
     *
     * @stability stable
     */
    readonly parentId: string;
    /**
     * The provider to use for the custom resource that will create the OU.
     *
     * You can create a provider with the OrganizationOuProvider class
     *
     * @stability stable
     */
    readonly provider: custom_resources.Provider;
}
/**
 * @stability stable
 */
export declare class OrganizationOU extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: OrganizationOUProps);
}
