# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['mctinctools']

package_data = \
{'': ['*']}

install_requires = \
['Faker>=13.15.1,<14.0.0',
 'Jinja2>=3.1.2,<4.0.0',
 'PyPDF2>=2.8.1,<3.0.0',
 'click>=8.1.3,<9.0.0',
 'interrogate>=1.5.0,<2.0.0',
 'mdx-gh-links>=0.3,<0.4',
 'mkdocs-gen-files>=0.3.5,<0.4.0',
 'mkdocs-literate-nav>=0.4.1,<0.5.0',
 'mkdocs-material>=8.3.9,<9.0.0',
 'mkdocstrings-python>=0.7.1,<0.8.0',
 'mkdocstrings>=0.19.0,<0.20.0',
 'openpyxl>=3.0.10,<4.0.0',
 'pandas>=1.4.3,<2.0.0',
 'pdfforms>=2.0.0,<3.0.0',
 'pdfminer.six>=20220524,<20220525',
 'pdfminer>=20191125,<20191126',
 'pdfplumber>=0.7.4,<0.8.0',
 'pre-commit>=2.20.0,<3.0.0',
 'pyarrow>=8.0.0,<9.0.0',
 'pytest>=7.1.2,<8.0.0',
 'python-dotenv>=0.20.0,<0.21.0',
 'reportlab>=3.6.11,<4.0.0',
 'rich>=12.5.1,<13.0.0']

entry_points = \
{'console_scripts': ['mctinctools = mctinctools.console:main']}

setup_kwargs = {
    'name': 'mctinctools',
    'version': '0.1.5',
    'description': 'Common tools for our organization.',
    'long_description': '# README.md\n\n## Base file using best practices\n- pytest for testing\n- precommit\n- black formatting\n- flake linting\n  - includes bandit for security scanning\n- mypy - type testing\n- mkdocs for automatic document preparation based on code\n- nox for automatic testing and building (python version of tox)\n- scriv for automatic changelog generation\n\n### Manual commands \n- Build requirements.txt from poetry\n\n```bash\n  poetry export -f requirements.txt > requirements.txt\n```\n- Build changelog data.\n```\nsciv create\n```\n- Edit file created.\n```\nedit changelog.d/AUTOGENERATEDFILENAME\nadd what you changed\n```\n- Collect the changelog to update CHANGELOG.rst\n```\nscriv collect\n\n```\n\n- Build package for upload to pypi.\n  - Get pypi authentication ready prior to publish\n  - Update version number in pyproject.toml prior to building\n```\nadd env variables\nput secret in env variables with\n$POETRY_HTTP_BASIC_PYPI_TOKEN\nexport POETRY_HTTP_BASIC_PYPI_TOKEN=PYPIAPIGOESHERE\npoetry config pypi-token.pypi $POETRY_HTTP_BASIC_PYPI_TOKEN\npoetry build\npoetry publish\n```\n',
    'author': 'forums34',
    'author_email': 'greg.wendel@hey.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/forums34/mctinctools',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
