# README.md

## Base file using best practices
- pytest for testing
- precommit
- black formatting
- flake linting
  - includes bandit for security scanning
- mypy - type testing
- mkdocs for automatic document preparation based on code
- nox for automatic testing and building (python version of tox)
- scriv for automatic changelog generation

### Manual commands 
- Build requirements.txt from poetry

```bash
  poetry export -f requirements.txt > requirements.txt
```
- Build changelog data.
```
sciv create
```
- Edit file created.
```
edit changelog.d/AUTOGENERATEDFILENAME
add what you changed
```
- Collect the changelog to update CHANGELOG.rst
```
scriv collect

```

- Build package for upload to pypi.
  - Get pypi authentication ready prior to publish
  - Update version number in pyproject.toml prior to building
```
add env variables
put secret in env variables with
$POETRY_HTTP_BASIC_PYPI_TOKEN
export POETRY_HTTP_BASIC_PYPI_TOKEN=PYPIAPIGOESHERE
poetry config pypi-token.pypi $POETRY_HTTP_BASIC_PYPI_TOKEN
poetry build
poetry publish
```
