import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='graphene-crud-maker',
    version='1.0.0',
    packages=find_packages(),
    include_package_data=True,
    license='MIT License',  # example license
    description='This is a project to auto generate a graphql crud using graphene django',
    long_description=README,
    long_description_content_type="text/markdown",
    url='https://github.com/dercio-sinione/graphene-crud-maker',
    project_urls={
        "Bug Tracker": "https://github.com/dercio-sinione/graphene-crud-maker/issues",
    },
    author='Dércio Sinione',
    author_email='derciosinione@gmail.com',
    contributors=[
       ['Dércio Sinione', 'derciosinione@gmail.com', 'maintainer'],
       ['Paulo Lopes Estevão', 'pl1745240@gmail.com', 'maintainer'],
     ],
    install_requires=[            # I get to this in a second
        'graphene',
        'django',
        'graphene-django',
        'django-filter',
    ],
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        'Framework :: Django',
        'Framework :: Django :: 1.11',  # replace "X.Y" as appropriate
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',  # example license
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        # Replace these appropriately if you are stuck on Python 2.
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        "Programming Language :: Python :: Implementation :: PyPy",
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
    python_requires=">=3",
)